/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.jira.bean.SubTaskBean;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import webwork.action.ActionContext;

public class HasSubTaskCondition
implements Condition {
    private final SubTaskManager subTaskManager;
    private final JiraAuthenticationContext authenticationContext;

    public HasSubTaskCondition(SubTaskManager subTaskManager, JiraAuthenticationContext authenticationContext) {
        this.subTaskManager = subTaskManager;
        this.authenticationContext = authenticationContext;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        SubTaskBean subTaskBean = this.getSubTaskBean(issue, context);
        boolean hasSubTasks = !subTaskBean.getSubTasks("all").isEmpty();
        return hasSubTasks;
    }

    private SubTaskBean getSubTaskBean(Issue issue, Map<String, Object> context) {
        HttpServletRequest request = this.getRequest(context);
        if (request != null) {
            SubTaskBean subtaskBean = (SubTaskBean)request.getAttribute("atl.jira.subtask.bean." + issue.getKey());
            if (subtaskBean != null) {
                return subtaskBean;
            }
            subtaskBean = this.subTaskManager.getSubTaskBean(issue, this.authenticationContext.getUser());
            request.setAttribute("atl.jira.subtask.bean." + issue.getKey(), (Object)subtaskBean);
            return subtaskBean;
        }
        return this.subTaskManager.getSubTaskBean(issue, this.authenticationContext.getUser());
    }

    protected HttpServletRequest getRequest(Map<String, Object> context) {
        HttpServletRequest request = null;
        JiraHelper jiraHelper = (JiraHelper)context.get("helper");
        if (jiraHelper != null && (request = jiraHelper.getRequest()) != null) {
            return request;
        }
        Object o = context.get("request");
        if (o != null && o instanceof HttpServletRequest) {
            request = (HttpServletRequest)o;
            return request;
        }
        request = ExecutingHttpRequest.get();
        if (request != null) {
            return request;
        }
        return ActionContext.getRequest();
    }
}

