/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.fields.util.FieldPredicates;
import com.atlassian.jira.issue.label.LabelUtil;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.views.SearchLinkGenerator;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugin.issueview.IssueViewModuleDescriptor;
import com.atlassian.jira.plugin.viewissue.web.FieldModelFactory;
import com.atlassian.jira.plugin.viewissue.web.SimpleTab;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.Maps;
import com.opensymphony.workflow.loader.StepDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import webwork.action.Action;

public class DetailsBlockContextProvider
implements ContextProvider {
    private final PluginAccessor pluginAccessor;
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectComponentManager projectComponentManager;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final LabelUtil labelUtil;
    private final FieldManager fieldManager;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final WorkflowManager workflowManager;
    private final SearchLinkGenerator searchLinkGenerator;
    private final MauEventService mauEventService;
    private VersionManager versionManager;
    private FieldModelFactory fieldModelFactory;

    public DetailsBlockContextProvider(PluginAccessor pluginAccessor, JiraAuthenticationContext authenticationContext, ProjectComponentManager projectComponentManager, FieldVisibilityManager fieldVisibilityManager, LabelUtil labelUtil, FieldManager fieldManager, FieldScreenRendererFactory fieldScreenRendererFactory, IssueManager issueManager, PermissionManager permissionManager, WorkflowManager workflowManager, SearchLinkGenerator searchLinkGenerator, VersionManager versionManager, MauEventService mauEventService, FieldModelFactory fieldModelFactory) {
        this.pluginAccessor = pluginAccessor;
        this.authenticationContext = authenticationContext;
        this.projectComponentManager = projectComponentManager;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.labelUtil = labelUtil;
        this.fieldManager = fieldManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.workflowManager = workflowManager;
        this.searchLinkGenerator = searchLinkGenerator;
        this.versionManager = versionManager;
        this.mauEventService = mauEventService;
        this.fieldModelFactory = fieldModelFactory;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder paramsBuilder = MapBuilder.newBuilder((Map)JiraVelocityUtils.getDefaultVelocityParams(context, (JiraAuthenticationContext)this.authenticationContext));
        Issue issue = (Issue)context.get("issue");
        this.mauEventService.setApplicationForThreadBasedOnProject(issue.getProjectObject());
        Action action = (Action)context.get("action");
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        paramsBuilder.add((Object)"i18n", (Object)this.authenticationContext.getI18nHelper());
        paramsBuilder.add((Object)"issue", (Object)issue);
        paramsBuilder.add((Object)"summaryComponent", (Object)this);
        paramsBuilder.add((Object)"fieldVisibility", (Object)this.fieldVisibilityManager);
        paramsBuilder.add((Object)"issueViews", this.getIssueViews());
        paramsBuilder.add((Object)"canEdit", (Object)this.issueManager.isEditable(issue, user));
        paramsBuilder.add((Object)"hasViewWorkflowPermission", (Object)this.permissionManager.hasPermission(ProjectPermissions.VIEW_READONLY_WORKFLOW, issue, user));
        JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
        if (workflow != null) {
            paramsBuilder.add((Object)"workflowName", (Object)workflow.getName());
            paramsBuilder.add((Object)"workflowUrl", (Object)this.getWorkflowUrl(workflow, issue));
        }
        Long projectId = issue.getProjectId();
        paramsBuilder.add((Object)"searchLinkGenerator", (Object)this.searchLinkGenerator);
        paramsBuilder.add((Object)"projectHasComponents", (Object)(!this.projectComponentManager.findAllForProject(projectId).isEmpty() ? 1 : 0));
        paramsBuilder.add((Object)"projectHasVersions", (Object)(!this.versionManager.getVersions(projectId).isEmpty() ? 1 : 0));
        paramsBuilder.add((Object)"labelUtil", (Object)this.labelUtil);
        paramsBuilder.add((Object)"renderedEnvironmentHtml", (Object)this.getRenderedEnvironmentFieldValue(issue, action));
        if (this.fieldModelFactory.hasRequestedFields(context)) {
            paramsBuilder.add((Object)"fields", this.fieldModelFactory.getFieldModels(context));
        } else {
            paramsBuilder.addAll(this.createCFTabs(issue, action));
        }
        return paramsBuilder.toMap();
    }

    private Map<String, Object> createCFTabs(Issue issue, Action action) {
        HashMap map = Maps.newHashMap();
        FieldScreenRenderer fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION, FieldPredicates.isStandardViewIssueCustomField());
        List fieldScreenRenderTabs = fieldScreenRenderer.getFieldScreenRenderTabs();
        List tabModels = fieldScreenRenderTabs.stream().map(tab -> new SimpleTab((FieldScreenRenderTab)tab, issue, action)).collect(Collectors.toList());
        map.put("tabs", tabModels);
        return map;
    }

    private Collection<IssueViewModuleDescriptor> getIssueViews() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(IssueViewModuleDescriptor.class);
    }

    private String getRenderedEnvironmentFieldValue(Issue issue, Action action) {
        if (StringUtils.isNotBlank((String)issue.getEnvironment())) {
            OrderableField environmentField = this.fieldManager.getOrderableField("environment");
            FieldScreenRenderer renderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION);
            FieldLayoutItem fieldLayoutItem = renderer.getFieldScreenRenderLayoutItem(environmentField).getFieldLayoutItem();
            return environmentField.getViewHtml(fieldLayoutItem, action, issue);
        }
        return null;
    }

    private String getWorkflowUrl(JiraWorkflow workflow, Issue issue) {
        if (workflow != null) {
            UrlBuilder url = new UrlBuilder(false).addPath("/").addPath("browse").addPath(issue.getKey()).addParameter("workflowName", workflow.getName());
            StepDescriptor step = workflow.getLinkedStep(issue.getStatusObject());
            if (step != null) {
                url.addParameter("stepId", Integer.toString(step.getId()));
            }
            return url.asUrlString();
        }
        return "";
    }
}

