/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.google.common.collect.Lists;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AttachmentSortingOptionsFactory
implements WebItemProvider {
    private static final String ITEM_SECTION = "com.atlassian.jira.jira-view-issue-plugin:attachmentmodule/drop/attachment-sorting-options";
    private final VelocityRequestContextFactory requestContextFactory;
    private final JiraAuthenticationContext authenticationContext;

    public AttachmentSortingOptionsFactory(VelocityRequestContextFactory requestContextFactory, JiraAuthenticationContext authenticationContext) {
        this.requestContextFactory = requestContextFactory;
        this.authenticationContext = authenticationContext;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        Issue issue = (Issue)context.get("issue");
        VelocityRequestSession session = requestContext.getSession();
        String baseUrl = requestContext.getBaseUrl();
        String sortingOrder = (String)session.getAttribute("jira.issue.attachment.sortby");
        boolean sortedByName = "fileName".equals(sortingOrder) || StringUtils.isBlank((String)sortingOrder);
        WebItem allLink = new WebFragmentBuilder(10).id("attachment-sort-key-name").label(i18n.getText("viewissue.attachments.sort.key.name")).title(i18n.getText("viewissue.subtasks.tab.show.all.name")).styleClass(sortedByName ? "aui-list-checked aui-checked" : "aui-list-checked").webItem(ITEM_SECTION).url(baseUrl + "/browse/" + issue.getKey() + "?attachmentSortBy=fileName#attachmentmodule").build();
        WebItem openLink = new WebFragmentBuilder(20).id("attachment-sort-key-date").label(i18n.getText("viewissue.attachments.sort.key.date")).title(i18n.getText("viewissue.attachments.sort.key.date")).styleClass(!sortedByName ? "aui-list-checked aui-checked" : "aui-list-checked").webItem(ITEM_SECTION).url(baseUrl + "/browse/" + issue.getKey() + "?attachmentSortBy=dateTime#attachmentmodule").build();
        return Lists.newArrayList((Object[])new WebItem[]{allLink, openLink});
    }
}

