/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentCreationDateComparator;
import com.atlassian.jira.issue.attachment.AttachmentFileNameCreationDateComparator;
import com.atlassian.jira.issue.fields.rest.json.dto.AttachmentViewDtoConverter;
import com.atlassian.jira.plugin.viewissue.AttachmentBlockContextHelper;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.plugin.PluginParseException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentBlockContextProvider
implements CacheableContextProvider {
    private static final Logger log = LoggerFactory.getLogger(AttachmentBlockContextProvider.class);
    private final AttachmentManager attachmentManager;
    private final JiraAuthenticationContext authenticationContext;
    private final AttachmentBlockContextHelper helper;
    private final AttachmentViewDtoConverter viewDtoConverter;

    public AttachmentBlockContextProvider(AttachmentManager attachmentManager, JiraAuthenticationContext authenticationContext, AttachmentBlockContextHelper helper, AttachmentViewDtoConverter viewDtoConverter) {
        this.attachmentManager = attachmentManager;
        this.authenticationContext = authenticationContext;
        this.viewDtoConverter = viewDtoConverter;
        this.helper = helper;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder paramsBuilder = MapBuilder.newBuilder(context);
        Issue issue = (Issue)context.get("issue");
        List attachments = this.attachmentManager.getAttachments(issue, this.attachmentComparator());
        paramsBuilder.add((Object)"hasAttachments", (Object)(!attachments.isEmpty() ? 1 : 0));
        paramsBuilder.add((Object)"openSquareBracket", (Object)JiraUrlCodec.encode((String)"["));
        paramsBuilder.add((Object)"closeSquareBracket", (Object)JiraUrlCodec.encode((String)"]"));
        paramsBuilder.add((Object)"viewMode", (Object)this.helper.getAttachmentViewMode());
        paramsBuilder.add((Object)"sortKey", (Object)this.helper.getAttachmentSortBy());
        paramsBuilder.add((Object)"sortOrder", (Object)this.helper.getAttachmentOrder());
        paramsBuilder.add((Object)"attachments", (Object)this.viewDtoConverter.convert(attachments));
        paramsBuilder.add((Object)"maximumNumberOfZipEntriesToShow", (Object)this.helper.getMaximumNumberOfZipEntriesToShow());
        paramsBuilder.add((Object)"fullBaseUrl", (Object)JiraUrl.constructBaseUrl((HttpServletRequest)AttachmentBlockContextProvider.getRequest(context)));
        return paramsBuilder.toMap();
    }

    protected Comparator<Attachment> attachmentComparator() {
        String attachmentSortBy = this.helper.getAttachmentSortBy();
        String attachmentOrder = this.helper.getAttachmentOrder();
        Object attachmentComparator = "dateTime".equals(attachmentSortBy) ? new AttachmentCreationDateComparator() : new AttachmentFileNameCreationDateComparator(this.authenticationContext.getLocale());
        if ("desc".equals(attachmentOrder)) {
            attachmentComparator = Collections.reverseOrder(attachmentComparator);
        }
        return attachmentComparator;
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        return issue.getId() + "/" + (user == null ? "" : user.getName());
    }

    private static HttpServletRequest getRequest(Map<String, Object> context) {
        return ((JiraHelper)context.get("helper")).getRequest();
    }
}

