/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.core.AtlassianCoreException;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentBlockContextHelper {
    private static final Logger log = LoggerFactory.getLogger(AttachmentBlockContextHelper.class);
    static final String ORDER_DESC = "desc";
    static final String DEFAULT_ISSUE_ATTACHMENTS_ORDER = "asc";
    static final String SORTBY_DATE_TIME = "dateTime";
    static final String DEFAULT_ISSUE_ATTACHMENTS_SORTBY = "fileName";
    static final String VIEWMODE_LIST = "list";
    static final String DEFAULT_ISSUE_ATTACHMENTS_VIEWMODE = "gallery";
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final UserPreferencesManager userPreferencesManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public AttachmentBlockContextHelper(VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, IssueManager issueManager, PermissionManager permissionManager, UserPreferencesManager userPreferencesManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.userPreferencesManager = userPreferencesManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public String getAttachmentOrder() {
        return this.getSessionBackedRequestParam("attachmentOrder", DEFAULT_ISSUE_ATTACHMENTS_ORDER, "jira.issue.attachment.order");
    }

    public String getAttachmentSortBy() {
        return this.getSessionBackedRequestParam("attachmentSortBy", DEFAULT_ISSUE_ATTACHMENTS_SORTBY, "jira.issue.attachment.sortby");
    }

    public String getAttachmentViewMode() {
        if (this.applicationProperties.getOption("jira.option.allowthumbnails")) {
            return this.getPreferencesBackedRequestParam("attachmentViewMode", DEFAULT_ISSUE_ATTACHMENTS_VIEWMODE, "jira.issue.attachment.viewmode");
        }
        return VIEWMODE_LIST;
    }

    private String getSessionBackedRequestParam(String requestParamName, String defaultValue, String sessionKey) {
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        VelocityRequestSession session = requestContext.getSession();
        return this.getBackedRequestParam(requestParamName, defaultValue, sessionKey, new SessionParamProvider(session));
    }

    private String getPreferencesBackedRequestParam(String requestParamName, String defaultValue, String sessionKey) {
        if (this.jiraAuthenticationContext.isLoggedInUser()) {
            ExtendedPreferences extendedPreferences = this.userPreferencesManager.getExtendedPreferences(this.jiraAuthenticationContext.getUser());
            return this.getBackedRequestParam(requestParamName, defaultValue, sessionKey, new PreferencesParamProvider(extendedPreferences));
        }
        return this.getSessionBackedRequestParam(requestParamName, defaultValue, sessionKey);
    }

    private String getBackedRequestParam(String requestParamName, String defaultValue, String sessionKey, ParamProvider provider) {
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        String requestParameter = requestContext.getRequestParameter(requestParamName);
        if (StringUtils.isNotBlank((String)requestParameter)) {
            if (requestParameter.equals(defaultValue)) {
                provider.removeAttribute(sessionKey);
                return defaultValue;
            }
            provider.setAttribute(sessionKey, requestParameter);
            return requestParameter;
        }
        String providerValue = provider.getAttribute(sessionKey);
        return StringUtils.isNotBlank((String)providerValue) ? providerValue : defaultValue;
    }

    boolean getZipSupport() {
        return this.applicationProperties.getOption("jira.attachment.allow.zip.support");
    }

    int getMaximumNumberOfZipEntriesToShow() {
        String maximumNumberOfZipEntriesToShowAsString = this.applicationProperties.getDefaultBackedString("jira.attachment.number.of.zip.entries");
        int maximumNumberOfZipEntriesToShow = 30;
        try {
            maximumNumberOfZipEntriesToShow = Integer.parseInt(maximumNumberOfZipEntriesToShowAsString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return maximumNumberOfZipEntriesToShow;
    }

    boolean canDeleteAttachment(Issue issue, Attachment attachment, ApplicationUser user) {
        return this.issueManager.isEditable(issue) && (this.permissionManager.hasPermission(38, issue, user) || this.permissionManager.hasPermission(39, issue, user) && this.isUserAttachmentAuthor(attachment, user));
    }

    private boolean isUserAttachmentAuthor(Attachment attachment, ApplicationUser user) {
        ApplicationUser attachmentAuthor = attachment.getAuthorObject();
        if (attachmentAuthor == null && user == null) {
            return true;
        }
        if (attachmentAuthor == null || user == null) {
            return false;
        }
        return attachmentAuthor.equals((Object)user);
    }

    private static class PreferencesParamProvider
    implements ParamProvider {
        private final ExtendedPreferences extendedPreferences;

        public PreferencesParamProvider(ExtendedPreferences extendedPreferences) {
            this.extendedPreferences = extendedPreferences;
        }

        @Override
        public void removeAttribute(String key) {
            try {
                if (this.extendedPreferences.containsValue(key)) {
                    this.extendedPreferences.remove(key);
                }
            }
            catch (AtlassianCoreException e) {
                log.error("Exception occurred while trying to remove property:", (Throwable)e);
            }
        }

        @Override
        public void setAttribute(String key, String value) {
            try {
                this.extendedPreferences.setText(key, value);
            }
            catch (AtlassianCoreException e) {
                log.error("Exception occurred while trying to set property:", (Throwable)e);
            }
        }

        @Override
        public String getAttribute(String key) {
            return this.extendedPreferences.getText(key);
        }
    }

    private static class SessionParamProvider
    implements ParamProvider {
        private final VelocityRequestSession session;

        public SessionParamProvider(VelocityRequestSession session) {
            this.session = session;
        }

        @Override
        public void removeAttribute(String key) {
            this.session.removeAttribute(key);
        }

        @Override
        public void setAttribute(String key, String value) {
            this.session.setAttribute(key, (Object)value);
        }

        @Override
        public String getAttribute(String key) {
            return (String)this.session.getAttribute(key);
        }
    }

    private static interface ParamProvider {
        public void removeAttribute(String var1);

        public void setAttribute(String var1, String var2);

        public String getAttribute(String var1);
    }
}

