/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.viewissue;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.issuetabpanel.GetActionsRequest;
import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelInvoker;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.issuetabpanel.ShowPanelRequest;
import com.atlassian.jira.plugin.util.ModuleDescriptorComparator;
import com.atlassian.jira.plugin.viewissue.events.IssueTabRenderedEvent;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ActivityBlockViewIssueContextProvider
implements CacheableContextProvider {
    private static final String ORDER_DESC = "desc";
    protected final Logger log = Logger.getLogger(ActivityBlockViewIssueContextProvider.class);
    private final PluginAccessor pluginAccessor;
    private final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory requestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final IssueTabPanelInvoker issueTabPanelInvoker;
    private final EventPublisher eventPublisher;
    private final Set<String> WHITELISTED_KEYS = ImmutableSet.of((Object)"com.atlassian.jira.plugin.system.issuetabpanels:all-tabpanel", (Object)"com.atlassian.jira.plugin.system.issuetabpanels:comment-tabpanel", (Object)"com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel", (Object)"com.atlassian.jira.plugin.system.issuetabpanels:changehistory-tabpanel", (Object)"com.atlassian.streams.streams-jira-plugin:activity-stream-issue-tab");

    public ActivityBlockViewIssueContextProvider(PluginAccessor pluginAccessor, JiraAuthenticationContext authenticationContext, VelocityRequestContextFactory requestContextFactory, ApplicationProperties applicationProperties, IssueTabPanelInvoker issueTabPanelInvoker, EventPublisher eventPublisher) {
        this.pluginAccessor = pluginAccessor;
        this.authenticationContext = authenticationContext;
        this.requestContextFactory = requestContextFactory;
        this.applicationProperties = applicationProperties;
        this.issueTabPanelInvoker = issueTabPanelInvoker;
        this.eventPublisher = eventPublisher;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        boolean isAsynchronous = (Boolean)this.consumeParam(context, "isAsynchronousRequest");
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = this.authenticationContext.getUser();
        MapBuilder paramsBuilder = MapBuilder.newBuilder(context);
        ArrayList<IssueTabPanelModuleDescriptor> tabPanelDescriptors = this.getTabPanels(issue, user);
        String currentPageKey = this.getCurrentTabPanel(tabPanelDescriptors);
        IssueTabPanelModuleDescriptor currentTabPanelModuleDescriptor = this.getTabPanelModuleDescriptor(currentPageKey, tabPanelDescriptors);
        String actionSortOrder = this.getActionSortOrder();
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        boolean showAllFlag = requestContext.getRequestParameter("showAll") != null;
        String focusId = requestContext.getRequestParameter("focusedCommentId");
        GetActionsRequest getActionsRequest = new GetActionsRequest(issue, user, isAsynchronous, showAllFlag, focusId);
        List issueActions = this.issueTabPanelInvoker.invokeGetActions(getActionsRequest, currentTabPanelModuleDescriptor);
        ArrayList actions = Lists.newArrayList((Iterable)issueActions);
        this.sort(actions, actionSortOrder);
        paramsBuilder.add((Object)"tabPanels", tabPanelDescriptors);
        paramsBuilder.add((Object)"hasPanels", (Object)(!tabPanelDescriptors.isEmpty() ? 1 : 0));
        paramsBuilder.add((Object)"currentPageKey", (Object)currentPageKey);
        paramsBuilder.add((Object)"currentTab", (Object)currentTabPanelModuleDescriptor);
        paramsBuilder.add((Object)"isSortable", (Object)(currentTabPanelModuleDescriptor.isSortable() && actions != null && actions.size() > 1 ? 1 : 0));
        paramsBuilder.add((Object)"actions", (Object)actions);
        paramsBuilder.add((Object)"hasActions", (Object)(actions != null && !actions.isEmpty() ? 1 : 0));
        paramsBuilder.add((Object)"actionError", (Object)(actions == null ? 1 : 0));
        paramsBuilder.add((Object)"actionsSortOrder", (Object)actionSortOrder);
        this.sendTabRenderedEvent(currentPageKey, tabPanelDescriptors, issue);
        return paramsBuilder.toMap();
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = this.authenticationContext.getUser();
        return issue.getId() + "/" + (user == null ? "" : user.getName());
    }

    private void sort(List<IssueAction> actions, String actionSortOrder) {
        if (ORDER_DESC.equals(actionSortOrder)) {
            Collections.reverse(actions);
        }
    }

    private String getActionSortOrder() {
        String defaultOrder = this.applicationProperties.getDefaultBackedString("jira.issue.actions.order");
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        String actionOrder = requestContext.getRequestParameter("actionOrder");
        VelocityRequestSession session = requestContext.getSession();
        if (StringUtils.isNotBlank((String)actionOrder)) {
            if (!actionOrder.equals(defaultOrder)) {
                session.setAttribute("jira.issue.action.order", (Object)actionOrder);
                return actionOrder;
            }
            session.removeAttribute("jira.issue.action.order");
            return defaultOrder;
        }
        actionOrder = (String)session.getAttribute("jira.issue.action.order");
        if (StringUtils.isNotBlank((String)actionOrder)) {
            return actionOrder;
        }
        return defaultOrder;
    }

    private String getCurrentTabPanel(List<IssueTabPanelModuleDescriptor> tabPanels) {
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        String page = requestContext.getRequestParameter("page");
        VelocityRequestSession session = requestContext.getSession();
        if (StringUtils.isNotBlank((String)page) && this.isTabPanelVisisble(page, tabPanels)) {
            session.setAttribute("jira.issue.page", (Object)page);
            return page;
        }
        page = (String)session.getAttribute("jira.issue.page");
        if (StringUtils.isNotBlank((String)page) && this.isTabPanelVisisble(page, tabPanels)) {
            return page;
        }
        return this.getDefaultPage(tabPanels);
    }

    private boolean isTabPanelVisisble(String tabPanelKey, List<IssueTabPanelModuleDescriptor> tabPanels) {
        return this.getTabPanelModuleDescriptor(tabPanelKey, tabPanels) != null;
    }

    private IssueTabPanelModuleDescriptor getTabPanelModuleDescriptor(String key, List<IssueTabPanelModuleDescriptor> tabPanels) {
        for (IssueTabPanelModuleDescriptor tabPanel : tabPanels) {
            if (!tabPanel.getCompleteKey().equals(key)) continue;
            return tabPanel;
        }
        return null;
    }

    private ArrayList<IssueTabPanelModuleDescriptor> getTabPanels(Issue issue, ApplicationUser user) {
        List allTabPanels = this.pluginAccessor.getEnabledModuleDescriptorsByClass(IssueTabPanelModuleDescriptor.class);
        ArrayList filteredTabPanels = Lists.newArrayListWithCapacity((int)allTabPanels.size());
        for (IssueTabPanelModuleDescriptor descriptor : allTabPanels) {
            if (!this.issueTabPanelInvoker.invokeShowPanel(new ShowPanelRequest(issue, user), descriptor)) continue;
            filteredTabPanels.add(descriptor);
        }
        Collections.sort(filteredTabPanels, ModuleDescriptorComparator.COMPARATOR);
        return filteredTabPanels;
    }

    private void sendTabRenderedEvent(String currentPageKey, List<IssueTabPanelModuleDescriptor> moduleDescriptors, Issue issue) {
        if (currentPageKey == null) {
            return;
        }
        int tabIndex = moduleDescriptors.stream().map(ModuleDescriptor::getCompleteKey).collect(Collectors.toList()).indexOf(currentPageKey);
        String whitelistedTabKey = currentPageKey;
        if (!this.WHITELISTED_KEYS.contains(currentPageKey)) {
            whitelistedTabKey = Hashing.md5().newHasher().putString((CharSequence)currentPageKey, Charset.defaultCharset()).hash().toString();
        }
        IssueTabRenderedEvent event = new IssueTabRenderedEvent(whitelistedTabKey, tabIndex, issue.getId());
        this.eventPublisher.publish((Object)event);
    }

    private String getDefaultPage(List<IssueTabPanelModuleDescriptor> issueTabPanels) {
        for (IssueTabPanelModuleDescriptor descriptor : issueTabPanels) {
            if (!descriptor.isDefault()) continue;
            return descriptor.getCompleteKey();
        }
        if (!issueTabPanels.isEmpty()) {
            return issueTabPanels.get(0).getCompleteKey();
        }
        return null;
    }

    private Object consumeParam(Map<String, Object> context, String paramName) {
        Object result = context.get(paramName);
        context.remove(paramName);
        return result;
    }
}

