/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.userprofile;

import com.atlassian.core.user.preferences.Preferences;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.userprofile.AbstractUserProfilePanel;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.JiraUserPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.VelocityParamFactory;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PreferencesUserProfilePanel
extends AbstractUserProfilePanel {
    private final ApplicationProperties applicationProperties;
    private final UserPreferencesManager preferencesManager;
    private final LocaleManager localeManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final TimeZoneService timeZoneManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public PreferencesUserProfilePanel(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, VelocityTemplatingEngine templatingEngine, VelocityParamFactory velocityParamFactory, UserPreferencesManager preferencesManager, LocaleManager localeManager, I18nHelper.BeanFactory i18nCachingFactory, TimeZoneService timeZoneManager) {
        super(jiraAuthenticationContext);
        this.applicationProperties = applicationProperties;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.preferencesManager = preferencesManager;
        this.localeManager = localeManager;
        this.i18nFactory = i18nCachingFactory;
        this.timeZoneManager = timeZoneManager;
    }

    public Map<String, Object> getContextMap(Map<String, Object> initialContext) {
        String localeName;
        ApplicationUser profileUser = (ApplicationUser)initialContext.get("profileUser");
        ApplicationUser currentUser = (ApplicationUser)initialContext.get("currentUser");
        Preferences preferences = this.preferencesManager.getPreferences(profileUser);
        String userLocale = preferences.getString("jira.user.locale");
        if (StringUtils.isNotBlank((CharSequence)userLocale)) {
            localeName = this.localeManager.getLocale(userLocale).getDisplayName(this.jiraAuthenticationContext.getLocale());
        } else {
            I18nHelper i18n = this.i18nFactory.getInstance(profileUser);
            localeName = i18n.getText("admin.common.phrases.default.locale", this.applicationProperties.getDefaultLocale().getDisplayName(this.jiraAuthenticationContext.getLocale()));
        }
        Map<String, Object> params = this.createVelocityParams(profileUser, currentUser);
        params.put("panelId", this.getId());
        params.put("user", profileUser);
        params.put("localeName", localeName);
        final SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        JiraServiceContext serviceContext = new JiraServiceContext(){

            public ErrorCollection getErrorCollection() {
                return simpleErrorCollection;
            }

            public ApplicationUser getLoggedInUser() {
                return PreferencesUserProfilePanel.this.jiraAuthenticationContext.getLoggedInUser();
            }

            public ApplicationUser getLoggedInApplicationUser() {
                return PreferencesUserProfilePanel.this.jiraAuthenticationContext.getLoggedInUser();
            }

            public I18nHelper getI18nBean() {
                return PreferencesUserProfilePanel.this.jiraAuthenticationContext.getI18nHelper();
            }
        };
        params.put("usesJiraTimeZone", this.timeZoneManager.usesJiraTimeZone(serviceContext));
        params.put("timezone", this.timeZoneManager.getUserTimeZoneInfo(serviceContext));
        params.put("pageSize", preferences.getLong("user.issues.per.page"));
        String mimeType = preferences.getString("user.notifications.mimetype");
        if ("html".equals(mimeType)) {
            params.put("mimeType", "HTML");
        } else {
            params.put("mimeType", "Text");
        }
        params.put("notifyOwnChanges", preferences.getBoolean("user.notify.own.changes"));
        params.put("sharePrivate", preferences.getBoolean("user.default.share.private"));
        params.put("keyboardShortcutsEnabled", !preferences.getBoolean("user.keyboard.shortcuts.disabled"));
        params.put("autoWatchPreference", this.getAutoWatchPreference(profileUser));
        params.put("showAutowatch", this.applicationProperties.getOption("jira.option.watching"));
        return params;
    }

    @Override
    public String getId() {
        return "preferences-profile-fragment";
    }

    private String getAutoWatchPreference(ApplicationUser user) {
        Preferences userPreferences = this.preferencesManager.getPreferences(user);
        if (userPreferences instanceof JiraUserPreferences) {
            JiraUserPreferences jiraUserPreferences = (JiraUserPreferences)userPreferences;
            boolean autoWatchForUserSet = this.preferencesContainsValue(user, "user.autowatch.disabled");
            if (autoWatchForUserSet) {
                boolean autoWatchDisabled = jiraUserPreferences.getBoolean("user.autowatch.disabled");
                return autoWatchDisabled ? "preferences.autowatch.disabled" : "preferences.autowatch.enabled";
            }
        }
        return "preferences.autowatch.inherit";
    }

    private boolean preferencesContainsValue(ApplicationUser user, String key) {
        PropertySet userPropertySet = ComponentAccessor.getUserPropertyManager().getPropertySet(user);
        return userPropertySet.exists(key);
    }
}

