AJS.test.require(["com.atlassian.jira.jira-tzdetect-plugin:tzdetect-lib"],function(){window.__tzTesting=true;var B=jQuery;var A={defaultPrefs:{tzid:"Australia/Eucla",tzname:"(GMT+8:45) Eucla",janOffset:525,julyOffset:525},curPrefs:{},setPref:function(C,D){A.curPrefs[C]=D},resetPrefs:function(){A.curPrefs=B.extend({},A.defaultPrefs)},i18n:function(C){return"~~!"+C+"!~~"},generateZoneData:function(E){if(typeof E==="string"){E=[E]}var L={};var F=[];var D=[];var I,C,J,H;for(var G=0,K=E.length;G<K;G++){I=E[G];H=I.split("/");C=H[0];J=H[1];if(!L[C]){L[C]=true;F.push({key:C,displayName:A.i18n(C)})}D.push({regionKey:C,city:J,timeZoneId:I,displayName:A.i18n(C)+"/"+A.i18n(J),gmtOffset:"(GMT+00:00)"})}return{regions:F,zones:D}}};module("tzdetect-banner",{setup:function(){A.resetPrefs();this.banner=JIRA.plugins.tzBanner;this.prefsStub=sinon.stub(this.banner,"getPreferences").returns(A.curPrefs);B(this.banner.$tzFlag).remove();this.banner.$tzFlag=null},teardown:function(){this.prefsStub.restore()}});test("banner is not re-shown if it already exists",function(){var C=this.stub(this.banner,"detectTimezoneOffsets");this.banner.init();equal(C.callCount,1,"detectTimezoneOffsets() is called in blank state");this.banner.$tzFlag=B("<div/>");this.banner.init();equal(C.callCount,1,"detectTimezoneOffsets() is not called when the banner exists")});test("banner is not shown when no tzid is found",function(){var C=this.stub(this.banner,"create");A.setPref("tzid","");this.banner.init();equal(C.callCount,0,"create() is not called")});test("banner is not shown when zone offsets match",function(){var C=this.stub(this.banner,"create");this.stub(this.banner,"getTzOffset").returns(525);this.banner.init();equal(C.callCount,0,"create() is not called")});test("banner is shown when zone offsets do not match",function(){var C=this.stub(this.banner,"create");this.stub(this.banner,"getTzOffset").returns(600);this.banner.init();equal(C.callCount,1,"create() is called")});test("banner silently does nothing if AJS.params is missing",function(){this.prefsStub.restore();var E=AJS.params;AJS.params={};var C=this.banner.getPreferences();var D={tzid:undefined,tzname:undefined,janOffset:0,julyOffset:0};deepEqual(C,D,"getPreferences() returns undefined for all keys");AJS.params=E});test("update for a single matching zone",function(){var D=this.stub(this.banner,"setUserTimeZone");var C=A.generateZoneData("Australia/Darwin");this.banner.handleZoneData(C);ok(D.calledWith("Australia/Darwin"),"A single zone sets the user pref")});test("update for multiple matching zones",function(){var D=this.stub(this.banner,"setUserTimeZone");var C=A.generateZoneData(["Australia/Sydney","Australia/Melbourne","Australia/Hobart"]);this.banner.$link=B();this.banner.$dropdown=null;this.banner.handleZoneData(C);equal(D.callCount,0,"User pref is not set");ok(this.banner.$dropdown instanceof B,"Menu is created")});test("GMT offset zones are filtered out in menu",function(){var C=A.generateZoneData(["Australia/Perth","Asia/Singapore","Etc/GMT-8"]);this.banner.$link=B();this.banner.$dropdown=null;this.banner.handleZoneData(C);equal(this.banner.$dropdown.find("a[data-tzid]").length,2,"GMT offset zone is ignored")});test("GMT offset and Antarctica zones are filtered out before getting to the menu",function(){var D=this.stub(this.banner,"setUserTimeZone");var C=A.generateZoneData(["Australia/Perth","Antarctica/Casey","Etc/GMT-8"]);this.banner.$link=B();this.banner.$dropdown=null;this.banner.handleZoneData(C);ok(D.calledWith("Australia/Perth"),"Single zone after ignoring GMT offset sets user pref");equal(this.banner.$dropdown,null,"Banner is not shown")});test("banner tracks analytics when shown",function(){var C=this.stub(this.banner,"track");this.stub(this.banner,"getTzOffset").returns(600);this.banner.init();ok(C.calledWith("shown"),"Banner showing is tracked")});test("banner tracks analytics when update link is clicked",function(){var D=this.stub(this.banner,"track");this.stub(this.banner,"redirect");this.banner.$link=B();var C=A.generateZoneData([]);this.banner.handleZoneData(C);ok(D.calledWith("clicked.update",{matchingZoneCount:0}),"Update with no matching zones is tracked")});test("banner tracks analytics when zone is set",function(){var C=this.stub(this.banner,"track");this.stub(JIRA.SmartAjax,"makeRequest");this.banner.setUserTimeZone("Australia/Eucla","qunit");ok(C.calledWith("setzone",{zoneId:"Australia/Eucla",source:"qunit"}),"Setting a zone is tracked with the zone ID")})});