/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.tzdetect;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.config.InstanceFeatureManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredData;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import java.io.IOException;
import java.util.TimeZone;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;

@Scanned
public class IncludeResourcesFilter
implements Filter {
    private final PageBuilderService pageBuilderService;
    private final TimeZoneService timeZoneService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final InstanceFeatureManager featureManager;

    public IncludeResourcesFilter(@ComponentImport PageBuilderService pageBuilderService, @ComponentImport TimeZoneService timeZoneService, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport InstanceFeatureManager featureManager) {
        this.pageBuilderService = pageBuilderService;
        this.timeZoneService = timeZoneService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.featureManager = featureManager;
    }

    private int getDateOffset(TimeZone timeZone, int month, int day) {
        DateTime now = new DateTime();
        DateTime dateTime = new DateTime(now.getYear(), month, day, 12, 0);
        return timeZone.getOffset(dateTime.toDate().getTime());
    }

    private int getJanOffset(TimeZone timeZone) {
        return this.getDateOffset(timeZone, 1, 1);
    }

    private int getJulyOffset(TimeZone timeZone) {
        return this.getDateOffset(timeZone, 7, 1);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isEnabled(servletRequest)) {
            WebResourceAssembler assembler = this.pageBuilderService.assembler();
            assembler.resources().requireWebResource("com.atlassian.jira.jira-tzdetect-plugin:tzdetect-lib");
            TimeZoneInfo timeZoneInfo = this.timeZoneService.getUserTimeZoneInfo((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getUser()));
            TimeZone timeZone = timeZoneInfo.toTimeZone();
            RequiredData requiredData = assembler.data();
            requiredData.requireData("tzdetect.pref.auto.detect", Boolean.valueOf(true));
            requiredData.requireData("tzdetect.pref.tzid", timeZoneInfo.getTimeZoneId());
            requiredData.requireData("tzdetect.pref.tzname", timeZoneInfo.getGMTOffset() + " " + timeZoneInfo.getCity());
            requiredData.requireData("tzdetect.pref.janOffset", (Number)this.getJanOffset(timeZone));
            requiredData.requireData("tzdetect.pref.julyOffset", (Number)this.getJulyOffset(timeZone));
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean isEnabled(ServletRequest servletRequest) {
        return this.userIsKnown() && this.isRelevantPath(servletRequest);
    }

    private boolean userIsKnown() {
        return !Users.isAnonymous((ApplicationUser)this.jiraAuthenticationContext.getUser());
    }

    private String getServletPath(ServletRequest servletRequest) {
        if (!HttpServletRequest.class.isInstance(servletRequest)) {
            throw new IllegalStateException("This is not HTTP request: " + servletRequest + ". I'm confused");
        }
        return ((HttpServletRequest)servletRequest).getServletPath();
    }

    private boolean isRelevantPath(ServletRequest servletRequest) {
        String requestPath = this.getServletPath(servletRequest);
        if (this.featureManager.isOnDemand()) {
            return requestPath.contains("/browse") || requestPath.endsWith("/secure/IssueNavigator.jspa") || requestPath.endsWith("/secure/Dashboard.jspa") || requestPath.endsWith("/secure/RapidBoard.jspa");
        }
        return !requestPath.endsWith("/logout") && !requestPath.startsWith("/secure/Logout");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

