define("jira/share-plugin/share-plugin-dialog",["jira/util/logger","jira/util/formatter","wrm/context-path","underscore","jira/share-plugin/share-user-picker","jira/ajs/layer/inline-layer","jira/ajs/ajax/smart-ajax","jira/util/events","jira/util/events/types","jira/util/data/meta","jira/util/events/reasons","aui/inline-dialog","jquery"],function(logger,formatter,wrmContextPath,_,ShareUserPickerElement,InlineLayer,SmartAjax,JiraEvents,JiraEventTypes,Meta,JiraEventReasons,InlineDialog,jQuery){return function(){var shareDialog;var currentShareLink;var dialogContents;var allowDialogHide=true;this.resetAndHide=function resetAndHide(){jQuery(document).one("hideLayer",function(e,type,dialog){if(type==="inlineDialog"&&dialog.popup===shareDialog){jQuery(document).unbind(".share-dialog");dialogContents.empty();dialogContents=undefined;currentShareLink=undefined}});return this.hideDialog()};this.hideDialog=function hideDialog(){shareDialog.hide();return false};function getUsernameValue(){return jQuery(this).attr("data-username")}function getEmailValue(){return jQuery(this).attr("data-email")}this._buildSendShareUrl=function buildSendShareUrl(options,data){var url=wrmContextPath()+"/rest/share/1.0";if(options.issue){url+="/issue/"+options.issueKey}else{if(options.filter){if(options.filterId){url+="/filter/"+options.filterId}else{data.jql=options.jql;url+="/search"}}}return url};this._successShareHandler=function successShareHandler(){var icon=dialogContents.find(".button-panel .icon");icon.removeClass("throbber loading").addClass("icon-tick");var messages=dialogContents.find(".progress-messages");messages.removeClass("sending").addClass("success").text(formatter.I18n.getText("jira-share-plugin.dialog.progress.sent"));setTimeout(_.bind(this.resetAndHide,this),1000)};this._errorShareHandler=function errorShareHandler(){var icon=dialogContents.find(".button-panel .icon");icon.removeClass("throbber loading").addClass("icon-cross");var messages=dialogContents.find(".progress-messages");messages.removeClass("sending").addClass("error").text(formatter.I18n.getText("jira-share-plugin.dialog.progress.error"))};this._sendShare=function sendShare(data,options){jQuery("button,input,textarea",this).attr("disabled","disabled");var icon=dialogContents.find(".button-panel .icon");icon.addClass("throbber loading");var messages=dialogContents.find(".progress-messages");messages.text(formatter.I18n.getText("jira-share-plugin.dialog.progress.sending"));messages.addClass("sending");var url=this._buildSendShareUrl(options,data);logger.trace("jira.plugins.share.send",_.defaults({url:url},data));var requestOptions={type:"POST",contentType:"application/json",dataType:"json",url:url,data:JSON.stringify(data),success:_.bind(this._successShareHandler,this),error:_.bind(this._errorShareHandler,this)};SmartAjax.makeRequest(requestOptions)};this._collectMailData=function collectMailData(){var recipients=dialogContents.find(".recipients");var users=recipients.find("li[data-username]").map(getUsernameValue).toArray();var emails=recipients.find("li[data-email]").map(getEmailValue).toArray();if(!(users.length||emails.length)){return false}var message=dialogContents.find("#note").val();var data={usernames:users,emails:emails,message:message};return data};this.submit=function submit(shareData){var mailData=this._collectMailData();if(mailData){this._sendShare(mailData,shareData)}return false};this._enableSubmit=function enableSubmit(enabled){dialogContents.find(".submit").prop("disabled",!enabled)};this.enableAccessKeys=function enableAccessKeys(shareDialogForm){jQuery(shareDialogForm).handleAccessKeys({selective:false})};this._getShareData=function getShareData(trigger){var $trigger=jQuery(trigger);var shareTarget;var permlinkFull;if($trigger.hasClass("viewissue-share")){shareTarget="issue";permlinkFull=Meta.get("viewissue-permlink")}else{if($trigger.hasClass("issuenav-share")){shareTarget="filter";permlinkFull=Meta.get("issuenav-permlink")}}var shareData={issueKey:Meta.get("issue-key"),filterId:Meta.get("filter-id"),jql:Meta.get("filter-jql"),permlink:permlinkFull};shareData[shareTarget]=true;return shareData};this._enableSubmitWhenIsRecipient=function enableSubmitWhenIsRecipient(){var shareNames=dialogContents.find("#sharenames").val();var isUserProvided=(shareNames!=null)&&(shareNames.length>0);this._enableSubmit(isUserProvided)};this._addInteractionHandlersToDialog=function addInteractionHandlersToDialog(shareData){dialogContents.find("#sharenames").bind("change unselect",_.bind(this._enableSubmitWhenIsRecipient,this));dialogContents.find(".close-dialog").click(_.bind(this.resetAndHide,this));dialogContents.find("form").submit(_.bind(this.submit,this,shareData));dialogContents.find(".issuenav-permalink .text").click(function(e){e.target.select();return false});jQuery(document).bind("keyup.share-dialog",_.bind(function(e){if(e.keyCode===jQuery.ui.keyCode.ESCAPE){return this.hideDialog()}return true},this));jQuery(document).bind("showLayer.share-dialog",function(e,type,dialog){if(type==="inlineDialog"&&dialog.popup===shareDialog){dialogContents.find("#sharenames-textarea").focus()}})};this._renderDialogContent=function renderDialogContent(shareData){dialogContents.html(JIRA.Templates.Dialogs.Share.contentPopup({shareData:shareData,modifierKey:Meta.get("keyboard-accesskey-modifier"),showForm:Meta.get("outgoing-mail-enabled"),isAdmin:Meta.get("is-admin")}))};this._generatePopup=function generatePopup(contents,trigger,doShowPopup){var shareData=this._getShareData(trigger);if(dialogContents&&currentShareLink===shareData.permlink){dialogContents=contents;doShowPopup();return }currentShareLink=shareData.permlink;dialogContents=contents;this._renderDialogContent(shareData);if(jQuery.browser.msie){dialogContents.find("form").ieImitationPlaceholder()}this._enableSubmit(false);this._addInteractionHandlersToDialog.call(this,shareData);this.enableAccessKeys(jQuery("form",dialogContents));doShowPopup();JiraEvents.trigger(JiraEventTypes.NEW_CONTENT_ADDED,[dialogContents,JiraEventReasons.shareDialogOpened])};this._scrollIntoViewForAuto=function _scrollIntoViewForAuto(){var self=this;var $context=jQuery(this.context);$context.scrollIntoViewForAuto({complete:function(){var scrollers=jQuery(this).add(window);_.delay(function(){scrollers.one("scroll",function(){jQuery(document.activeElement).blur();self.hideDialog()})},20)}})};this._createDialogOptions=function _createDialogOptions(dialogId){var offsetX=(dialogId.indexOf("issuenav")!==-1)?-110:-170;var dialogOptions={preHideCallback:function(){return allowDialogHide},hideCallback:function(){jQuery(".dashboard-actions .explanation").hide()},offsetY:17,offsetX:offsetX,hideDelay:3600000,useLiveEvents:true,initCallback:_.bind(this._scrollIntoViewForAuto,this)};return dialogOptions};this._addAJSInlineLayerEventHandlers=function _addAJSInlineLayerEventHandlers(){JiraEvents.bind(InlineLayer.EVENTS.beforeShow,function(e,layer,id){if(id==="sharenames-layer"){allowDialogHide=false}});JiraEvents.bind(InlineLayer.EVENTS.hide,function(e,layer,reason,id){if(id==="sharenames-layer"){setTimeout(function(){allowDialogHide=true},0)}})};this._initShareDialog=function _initShareDialog(dialogId,context){var self=this;this.context=context;this._addAJSInlineLayerEventHandlers();var dialogOptions=this._createDialogOptions(dialogId);shareDialog=InlineDialog(jQuery(context),dialogId,_.bind(self._generatePopup,self),dialogOptions);shareDialog[0].popup._validateClickToClose=function(event){return validationResult=shareDialog.has(event.target).length===0};jQuery(context).live("click",function(){if(shareDialog.find(".contents:visible").length){shareDialog.find("a.close-dialog").click()}});jQuery(document).bind("keydown",function(e){if(e.keyCode===jQuery.ui.keyCode.ESCAPE&&InlineDialog.current!==shareDialog&&shareDialog.is(":visible")){if(InlineDialog.current){InlineDialog.current.hide()}shareDialog.hide()}})};this._overrideContents=function overrideContents(newContents){dialogContents=newContents};this._getCurrentDialogContent=function getCurrentDialogContent(){return dialogContents};this._getAllowDialogHide=function _getAllowDialogHide(){return allowDialogHide}}});AJS.namespace("JIRA.JiraSharePlugin.SharePluginDialog",null,require("jira/share-plugin/share-plugin-dialog"));