/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.share.issue;

import com.atlassian.jira.notification.AdhocNotificationService;
import com.atlassian.jira.notification.NotificationBuilder;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.util.TextUtils;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class NotificationBuilderFactory {
    private final AdhocNotificationService adhocNotificationService;

    @Autowired
    public NotificationBuilderFactory(@ComponentImport AdhocNotificationService adhocNotificationService) {
        this.adhocNotificationService = adhocNotificationService;
    }

    public NotificationBuilder createNotificationBuilder(String message, NotificationRecipient recipient, Set<NotificationRecipient> otherRecipients) {
        NotificationBuilder notificationBuilder = this.adhocNotificationService.makeBuilder();
        this.addRecipientToNotification(notificationBuilder, recipient);
        ImmutableMap<String, Object> params = this.createNotificationParams(message, recipient, otherRecipients);
        notificationBuilder.setTemplate("share-issue.vm");
        notificationBuilder.setTemplateParams(params);
        return notificationBuilder;
    }

    private ImmutableMap<String, Object> createNotificationParams(String message, NotificationRecipient recipient, Set<NotificationRecipient> otherRecipients) {
        ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
        if (StringUtils.isNotBlank((String)message)) {
            paramsBuilder.put((Object)"comment", (Object)message);
            paramsBuilder.put((Object)"htmlComment", (Object)TextUtils.htmlEncode((String)message));
        }
        paramsBuilder.put((Object)"recipient", (Object)recipient);
        paramsBuilder.put((Object)"involvedUsers", otherRecipients);
        return paramsBuilder.build();
    }

    private void addRecipientToNotification(NotificationBuilder notificationBuilder, NotificationRecipient recipient) {
        if (recipient.getUser() != null) {
            notificationBuilder.addToUser(recipient.getUser().getName());
        } else if (recipient.getEmail() != null) {
            notificationBuilder.addToEmail(recipient.getEmail());
        }
    }
}

