/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.share;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.plugins.share.ShareBean;
import com.atlassian.jira.plugins.share.ShareService;
import com.atlassian.jira.plugins.share.issue.ShareIssueService;
import com.atlassian.jira.plugins.share.search.ShareSearchRequestService;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public final class ShareServiceImpl
implements ShareService {
    public static final String NO_USERS_OR_EMAILS_PROVIDED = "jira-share-plugin.no.users.or.emails.provided";
    public static final String NO_PERMISSION_TO_BROWSE_USERS = "jira-share-plugin.no.permission.to.browse.users";
    private final I18nHelper i18nHelper;
    private final PermissionManager permissionManager;
    private final ShareIssueService shareIssueService;
    private final ShareSearchRequestService shareSearchRequestService;

    @Autowired
    public ShareServiceImpl(@ComponentImport I18nHelper i18nHelper, @ComponentImport PermissionManager permissionManager, ShareIssueService shareIssueService, ShareSearchRequestService shareSearchRequestService) {
        this.shareIssueService = shareIssueService;
        this.shareSearchRequestService = shareSearchRequestService;
        this.i18nHelper = (I18nHelper)Assertions.notNull((Object)i18nHelper);
        this.permissionManager = (PermissionManager)Assertions.notNull((Object)permissionManager);
    }

    @Override
    public ShareService.ValidateShareIssueResult validateShareIssue(ApplicationUser remoteUser, ShareBean shareBean, Issue issue) {
        ErrorCollection errors = this.validateShare(remoteUser, shareBean);
        return new ShareService.ValidateShareIssueResult(errors, remoteUser, shareBean, issue);
    }

    @Override
    public void shareIssue(ShareService.ValidateShareIssueResult result) {
        if (!result.isValid()) {
            throw new IllegalStateException("Validation result was not valid.");
        }
        this.shareIssueService.shareIssue(result);
    }

    @Override
    public ShareService.ValidateShareSearchRequestResult validateShareSearchRequest(ApplicationUser remoteUser, ShareBean shareBean, SearchRequest searchRequest) {
        ErrorCollection errors = this.validateShare(remoteUser, shareBean);
        return new ShareService.ValidateShareSearchRequestResult(errors, remoteUser, shareBean, searchRequest);
    }

    @Override
    public void shareSearchRequest(ShareService.ValidateShareSearchRequestResult result) {
        if (!result.isValid()) {
            throw new IllegalStateException("Validation result was not valid.");
        }
        this.shareSearchRequestService.shareSearchRequest(result);
    }

    private ErrorCollection validateShare(ApplicationUser remoteUser, ShareBean shareBean) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (shareBean.getUsernames().isEmpty() && shareBean.getEmails().isEmpty()) {
            errors.addErrorMessage(this.i18nHelper.getText(NO_USERS_OR_EMAILS_PROVIDED));
        }
        if (!this.permissionManager.hasPermission(27, remoteUser)) {
            errors.addErrorMessage(this.i18nHelper.getText(NO_PERMISSION_TO_BROWSE_USERS));
        }
        return errors;
    }
}

