/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.upgrade;

import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTo_v1
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(PluginUpgradeTask.class);
    private static final String MARKER = "#-#-#";
    private static final Pattern MARKER_PATTERN = Pattern.compile("#-#-#([\\d]+)");
    private final JiraPropertySetFactory jiraPropertySetFactory;
    private final OfBizDelegator ofBizDelegator;

    public UpgradeTo_v1(JiraPropertySetFactory jiraPropertySetFactory, OfBizDelegator ofBizDelegator) {
        this.jiraPropertySetFactory = jiraPropertySetFactory;
        this.ofBizDelegator = ofBizDelegator;
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Convert Strings that were split because they were larger than 255 characters to one row.";
    }

    public Collection<Message> doUpgrade() throws Exception {
        log.info("Loading all string properties with values like #-#-#%, this may take some time...");
        List properties = this.ofBizDelegator.findByLike("OSPropertyString", (Map)FieldMap.build((String)"value", (Object)"#-#-#%"), Collections.emptyList());
        log.info("Done. Converting " + properties.size() + " properties...");
        for (GenericValue gv : properties) {
            String value = gv.getString("value");
            Matcher matcher = MARKER_PATTERN.matcher(value);
            if (!matcher.matches()) continue;
            int parts = Integer.parseInt(matcher.group(1));
            long id = gv.getLong("id");
            GenericValue entry = this.ofBizDelegator.findByPrimaryKey("OSPropertyEntry", Long.valueOf(id));
            if (entry == null) continue;
            String entityName = entry.getString("entityName");
            long entityId = entry.getLong("entityId");
            String key = entry.getString("propertyKey");
            PropertySet propertySet = this.jiraPropertySetFactory.buildNoncachingPropertySet(entityName, Long.valueOf(entityId));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < parts; ++i) {
                String partKey = key + MARKER + i;
                String propertyValue = propertySet.getString(partKey);
                if (propertyValue == null) continue;
                sb.append(propertyValue);
                propertySet.remove(partKey);
            }
            propertySet.remove(key);
            propertySet.setText(key, sb.toString());
        }
        log.info("Conversion complete.");
        return null;
    }

    public String getPluginKey() {
        return "com.atlassian.sal.jira";
    }
}

