/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.rdbms;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.fugue.Option;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.sal.api.rdbms.ConnectionCallback;
import com.atlassian.sal.jira.rdbms.ManagedOfBizConnection;
import com.atlassian.sal.spi.HostConnectionAccessor;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraHostConnectionAccessor
implements HostConnectionAccessor {
    private static final Logger log = LoggerFactory.getLogger(JiraHostConnectionAccessor.class);
    private final DatabaseAccessor databaseAccessor;
    private final Option<String> schemaName;

    public JiraHostConnectionAccessor(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
        this.schemaName = Option.option(databaseAccessor.getSchemaName().orElse(null));
    }

    public <A> A execute(boolean readOnly, boolean newTransaction, @Nonnull ConnectionCallback<A> callback) {
        if (newTransaction) {
            return this.borrowConnectionAndExecute(readOnly, callback);
        }
        Connection existingConnection = CoreTransactionUtil.getConnection();
        if (existingConnection == null) {
            return this.borrowConnectionAndExecute(readOnly, callback);
        }
        return this.executeInExistingTransaction(callback, existingConnection);
    }

    private <A> A borrowConnectionAndExecute(boolean readOnly, ConnectionCallback<A> callback) {
        return (A)this.databaseAccessor.executeQuery(connection -> {
            connection.setAutoCommit(false);
            try {
                connection.getJdbcConnection().setReadOnly(readOnly);
            }
            catch (SQLException e) {
                throw new DataAccessException((Throwable)e);
            }
            try {
                Object object = callback.execute(connection.getJdbcConnection());
                return object;
            }
            finally {
                if (readOnly) {
                    try {
                        connection.getJdbcConnection().setReadOnly(false);
                    }
                    catch (SQLException ex) {
                        log.error("Unable to unset the read-only flag on a borrowed DB Connection ... chaos will ensue.", (Throwable)ex);
                    }
                }
            }
        });
    }

    private <A> A executeInExistingTransaction(ConnectionCallback<A> callback, Connection existingConnection) {
        ManagedOfBizConnection nestedConection = new ManagedOfBizConnection(existingConnection);
        return (A)callback.execute((Connection)((Object)nestedConection));
    }

    @Nonnull
    public Option<String> getSchemaName() {
        return this.schemaName;
    }
}

