/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.pluginsettings;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class LazyProjectMigratingPropertySet {
    public static PropertySet create(ProjectManager projectManager, JiraPropertySetFactory jiraPropertySetFactory, PropertySet propertySet, String propertyKey) {
        return (PropertySet)Proxy.newProxyInstance(PropertySet.class.getClassLoader(), new Class[]{PropertySet.class}, (InvocationHandler)new PropertySetInvocationHandler(projectManager, jiraPropertySetFactory, propertySet, propertyKey));
    }

    static class PropertySetInvocationHandler
    implements InvocationHandler {
        private final ProjectManager projectManager;
        private final JiraPropertySetFactory jiraPropertySetFactory;
        private final PropertySet target;
        private final String projectKey;
        private boolean projectPropertySetInitialised;
        private PropertySet projectPropertySet;

        private PropertySetInvocationHandler(ProjectManager projectManager, JiraPropertySetFactory jiraPropertySetFactory, PropertySet target, String projectKey) {
            this.projectManager = projectManager;
            this.jiraPropertySetFactory = jiraPropertySetFactory;
            this.target = target;
            this.projectKey = projectKey;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("exists")) {
                return this.exists((String)args[0]);
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                throw cause != null ? cause : new RuntimeException(ite);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean exists(String key) {
            if (this.target.exists(key)) {
                return true;
            }
            PropertySetInvocationHandler propertySetInvocationHandler = this;
            synchronized (propertySetInvocationHandler) {
                if (!this.projectPropertySetInitialised) {
                    this.projectPropertySetInitialised = true;
                    Project project = this.projectManager.getProjectObjByKey(this.projectKey);
                    if (project != null) {
                        this.projectPropertySet = this.jiraPropertySetFactory.buildCachingPropertySet("Project", project.getId());
                    }
                }
                if (this.projectPropertySet != null && this.projectPropertySet.exists(key)) {
                    switch (this.projectPropertySet.getType(key)) {
                        case 5: {
                            this.target.setString(key, this.projectPropertySet.getString(key));
                            this.projectPropertySet.remove(key);
                            return true;
                        }
                        case 6: {
                            this.target.setText(key, this.projectPropertySet.getText(key));
                            this.projectPropertySet.remove(key);
                            return true;
                        }
                    }
                }
                return false;
            }
        }
    }
}

