/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.pluginsettings;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.PropertiesManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.propertyset.CachingOfBizPropertyEntryStore;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.jira.pluginsettings.CacheInvalidatingPluginSettings;
import com.atlassian.sal.jira.pluginsettings.ClusterSafePluginSettings;
import com.atlassian.sal.jira.pluginsettings.JiraPluginSettings;
import com.atlassian.sal.jira.pluginsettings.LazyProjectMigratingPropertySet;
import com.atlassian.util.concurrent.Supplier;
import com.atlassian.util.concurrent.Suppliers;
import com.opensymphony.module.propertyset.PropertySet;

public class JiraPluginSettingsFactory
implements PluginSettingsFactory {
    private static final String JIRA_PROPERTIES_ENTITY_NAME = "jira.properties";
    private static final Long JIRA_PROPERTIES_ENTITY_ID = 1L;
    private final JiraPropertySetFactory jiraPropertySetFactory;
    private final ProjectManager projectManager;

    public JiraPluginSettingsFactory(JiraPropertySetFactory jiraPropertySetFactory, ProjectManager projectManager) {
        this.jiraPropertySetFactory = jiraPropertySetFactory;
        this.projectManager = projectManager;
    }

    public PluginSettings createSettingsForKey(String key) {
        if (key == null) {
            return this.createGlobalSettings();
        }
        Supplier propertySet = Suppliers.memoize((Object)LazyProjectMigratingPropertySet.create(this.projectManager, this.jiraPropertySetFactory, this.jiraPropertySetFactory.buildCachingDefaultPropertySet(key), key));
        return new JiraPluginSettings((Supplier<? extends PropertySet>)propertySet);
    }

    public PluginSettings createGlobalSettings() {
        Supplier propertySet = ((PropertiesManager)ComponentAccessor.getComponent(PropertiesManager.class)).getPropertySetReference();
        Runnable invalidateCacheOperation = ComponentAccessor.getComponentSafely(CachingOfBizPropertyEntryStore.class).map(this::invalidateCacheOperation).orElse(() -> {});
        JiraPluginSettings defaultPluginSettings = new JiraPluginSettings((Supplier<? extends PropertySet>)propertySet);
        CacheInvalidatingPluginSettings cacheInvalidatingPluginSettings = new CacheInvalidatingPluginSettings((PluginSettings)defaultPluginSettings, invalidateCacheOperation);
        return new ClusterSafePluginSettings(cacheInvalidatingPluginSettings, (PluginSettings)defaultPluginSettings);
    }

    private Runnable invalidateCacheOperation(CachingOfBizPropertyEntryStore store) {
        return () -> store.invalidateCacheEntry(JIRA_PROPERTIES_ENTITY_NAME, JIRA_PROPERTIES_ENTITY_ID.longValue());
    }
}

