/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.pluginsettings;

import com.atlassian.sal.core.pluginsettings.AbstractStringPluginSettings;
import com.atlassian.util.concurrent.Supplier;
import com.opensymphony.module.propertyset.PropertySet;

public class JiraPluginSettings
extends AbstractStringPluginSettings {
    private static final int STRING_PROPERTY_MAX_LENGTH = 255;
    private Supplier<? extends PropertySet> propertySetRef;

    public JiraPluginSettings(Supplier<? extends PropertySet> set) {
        this.propertySetRef = set;
    }

    protected void removeActual(String key) {
        ((PropertySet)this.propertySetRef.get()).remove(key);
    }

    protected void putActual(String key, String val) {
        PropertySet propertySet = (PropertySet)this.propertySetRef.get();
        if (key != null && propertySet.exists(key)) {
            propertySet.remove(key);
        }
        if (val.length() > 255) {
            propertySet.setText(key, val);
        } else {
            propertySet.setString(key, val);
        }
    }

    protected String getActual(String key) {
        PropertySet propertySet = (PropertySet)this.propertySetRef.get();
        if (!propertySet.exists(key)) {
            return null;
        }
        switch (propertySet.getType(key)) {
            case 5: {
                return propertySet.getString(key);
            }
            case 6: {
                return propertySet.getText(key);
            }
        }
        return null;
    }
}

