/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.lifecycle;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.sal.core.lifecycle.DefaultLifecycleManager;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.ListableBeanFactory;

public class JiraLifecycleManager
extends DefaultLifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultLifecycleManager.class);
    private final List<ListableBeanFactory> beanFactories;

    public JiraLifecycleManager(PluginEventManager pluginEventManager, PluginAccessor pluginAccessor, BundleContext bundleContext, List<ListableBeanFactory> beanFactories) {
        super(pluginEventManager, pluginAccessor, bundleContext);
        this.beanFactories = beanFactories;
    }

    public boolean isApplicationSetUp() {
        return ComponentAccessor.getApplicationProperties().getString("jira.setup") != null;
    }

    @PluginEventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
    }

    @PluginEventListener
    public void onJiraStart(JiraStartedEvent event) {
        log.debug("Jira Started event received.");
        this.start();
    }

    protected void notifyOnStart() {
        super.notifyOnStart();
        for (ListableBeanFactory lbf : this.beanFactories) {
            String[] names;
            for (String name : names = lbf.getBeanDefinitionNames()) {
                try {
                    Object bean;
                    if (!lbf.isSingleton(name) || !((bean = lbf.getBean(name)) instanceof Startable)) continue;
                    try {
                        ((Startable)bean).start();
                    }
                    catch (Exception e) {
                        log.error("Error occurred while starting component '" + bean.getClass().getName() + "'. " + e.getMessage(), (Throwable)e);
                    }
                }
                catch (BeanIsAbstractException beanIsAbstractException) {
                    // empty catch block
                }
            }
        }
    }
}

