/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.license;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationConfigurationHelper;
import com.atlassian.jira.application.ApplicationRole;
import com.atlassian.jira.application.ApplicationRoleDefinitions;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.application.ApplicationRoleStore;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.sal.api.i18n.InvalidOperationException;
import com.atlassian.sal.api.license.BaseLicenseDetails;
import com.atlassian.sal.api.license.LicenseChangedEvent;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.atlassian.sal.api.validate.ValidationResult;
import com.atlassian.sal.jira.license.BaseLicenseDetailsImpl;
import com.atlassian.sal.jira.license.MultiProductLicenseDetailsImpl;
import com.atlassian.sal.jira.license.SingleProductLicenseDetailsViewImpl;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JiraLicenseHandler
implements LicenseHandler,
InitializingBean,
DisposableBean {
    private final JiraLicenseService jiraLicenseService;
    private final JiraLicenseManager jiraLicenseManager;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private final ApplicationRoleManager applicationRoleManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager permissionManager;
    private final GroupManager groupManager;
    private final ApplicationConfigurationHelper appConfigHelper;

    public JiraLicenseHandler(@Nonnull JiraLicenseService jiraLicenseService, @Nonnull JiraLicenseManager jiraLicenseManager, @Nonnull I18nHelper.BeanFactory i18nBeanFactory, @Nonnull ApplicationProperties applicationProperties, @Nonnull EventPublisher eventPublisher, @Nonnull JiraAuthenticationContext jiraAuthenticationContext, @Nonnull GlobalPermissionManager permissionManager, @Nonnull GroupManager groupManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.jiraLicenseService = (JiraLicenseService)Preconditions.checkNotNull((Object)jiraLicenseService, (Object)"jiraLicenseService");
        this.jiraLicenseManager = (JiraLicenseManager)Preconditions.checkNotNull((Object)jiraLicenseManager, (Object)"jiraLicenseManager");
        this.i18nBeanFactory = (I18nHelper.BeanFactory)Preconditions.checkNotNull((Object)i18nBeanFactory, (Object)"i18nBeanFactory");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher, (Object)"eventPublisher");
        this.applicationRoleManager = (ApplicationRoleManager)Preconditions.checkNotNull((Object)ComponentAccessor.getComponent(ApplicationRoleManager.class), (Object)"applicationRoleManager");
        this.permissionManager = permissionManager;
        this.groupManager = groupManager;
        this.appConfigHelper = (ApplicationConfigurationHelper)Preconditions.checkNotNull((Object)ComponentAccessor.getComponent(ApplicationConfigurationHelper.class), (Object)"appConfigHelper");
    }

    public void setLicense(String license) {
        JiraLicenseService.ValidationResult validationResult = this.jiraLicenseService.validate(this.i18nBeanFactory.getInstance(Locale.getDefault()), license);
        if (validationResult.getErrorCollection().hasAnyErrors()) {
            throw new IllegalArgumentException("Specified license was invalid.");
        }
        this.jiraLicenseManager.clearAndSetLicense(license);
    }

    public boolean hostAllowsMultipleLicenses() {
        return true;
    }

    public boolean hostAllowsCustomProducts() {
        return true;
    }

    public Set<String> getProductKeys() {
        HashSet productKeys = Sets.newHashSet();
        for (LicenseDetails licenseDetails : this.jiraLicenseManager.getLicenses()) {
            for (ApplicationKey key : licenseDetails.getLicensedApplications().getKeys()) {
                productKeys.add(key.value());
            }
        }
        return productKeys;
    }

    public void addProductLicense(@Nonnull String productKey, @Nonnull String license) throws InvalidOperationException {
        Preconditions.checkNotNull((Object)productKey, (Object)"Product Key required");
        Preconditions.checkNotNull((Object)license, (Object)"License required");
        ValidationResult validationResult = this.validateProductLicense(productKey, license, Locale.ENGLISH);
        if (validationResult.hasErrors()) {
            String join = StringUtils.join(validationResult.getErrorMessages().iterator(), (String)",\n");
            throw new InvalidOperationException(join, join);
        }
        this.jiraLicenseManager.setLicense(license);
    }

    public void removeProductLicense(@Nonnull String productKey) throws InvalidOperationException {
        Preconditions.checkArgument((boolean)ApplicationKey.isValid((String)productKey), (Object)"productKey is invalid.");
        try {
            this.jiraLicenseManager.removeLicense(ApplicationKey.valueOf((String)productKey));
        }
        catch (IllegalStateException e) {
            throw new InvalidOperationException("Unable to remove license, JIRA needs to contain at least one license to be functional", this.i18nBeanFactory.getInstance(this.jiraAuthenticationContext.getLoggedInUser()).getText("admin.errors.cannot.remove.license.required"));
        }
    }

    @Nonnull
    public ValidationResult validateProductLicense(@Nonnull String productKey, @Nonnull String license, @Nullable Locale locale) {
        Optional appConfigMessage;
        Locale localeForMessages = locale == null ? this.applicationProperties.getDefaultLocale() : locale;
        I18nHelper i18nHelper = this.i18nBeanFactory.getInstance(localeForMessages);
        if (StringUtils.isBlank((String)productKey) || !ApplicationKey.isValid((String)productKey)) {
            return ValidationResult.withErrorMessages((Iterable)Sets.newHashSet((Object[])new String[]{i18nHelper.getText("jira.license.validation.invalid.product.key")}));
        }
        ApplicationKey applicationKeyForLicense = ApplicationKey.valueOf((String)productKey);
        JiraLicenseService.ValidationResult validationResult = this.jiraLicenseService.validate(applicationKeyForLicense, license, i18nHelper);
        if (validationResult.getErrorCollection().hasAnyErrors()) {
            return ValidationResult.withErrorMessages(validationResult.getErrorCollection().getErrors().values());
        }
        LicensedApplications applicationsToLicense = this.jiraLicenseManager.getLicense(license).getLicensedApplications();
        ValidationResult productLicenseErrors = this.validateProductLicenseErrors(i18nHelper, applicationsToLicense, applicationKeyForLicense);
        if (productLicenseErrors.hasErrors()) {
            return productLicenseErrors;
        }
        ValidationResult licenseValidationResult = this.validateProductLicenseWarnings(i18nHelper, applicationsToLicense);
        if (licenseValidationResult.isValid() && (appConfigMessage = this.appConfigHelper.validateApplicationForConfiguration(applicationKeyForLicense, this.jiraAuthenticationContext.getLoggedInUser())).isPresent()) {
            return ValidationResult.withWarningMessages((Iterable)Sets.newHashSet((Object[])new String[]{(String)appConfigMessage.get()}));
        }
        return licenseValidationResult;
    }

    private ValidationResult validateProductLicenseErrors(I18nHelper i18nHelper, LicensedApplications appsToLicense, ApplicationKey appKey) {
        if (!appsToLicense.getKeys().contains(appKey)) {
            String notThisProductErrorMessage = i18nHelper.getText("jira.license.validation.product.key.not.for.license");
            return ValidationResult.withErrorMessages((Iterable)Sets.newHashSet((Object[])new String[]{notThisProductErrorMessage}));
        }
        return ValidationResult.valid();
    }

    private ValidationResult validateProductLicenseWarnings(I18nHelper i18nHelper, LicensedApplications licensedApplications) {
        ValidationResult userLimit = this.validateProductLicenseUserLimit(i18nHelper, licensedApplications);
        if (userLimit.hasWarnings()) {
            return userLimit;
        }
        ValidationResult activableUsers = this.validateActivateExistingUsers(i18nHelper, licensedApplications);
        if (activableUsers.hasWarnings()) {
            return activableUsers;
        }
        return ValidationResult.valid();
    }

    private ValidationResult validateProductLicenseUserLimit(I18nHelper i18nHelper, LicensedApplications licensedApplications) {
        HashSet warningMessages = Sets.newHashSet();
        for (ApplicationRole licensedApplicationRole : this.applicationRoleManager.getRoles()) {
            ApplicationKey licensedApplicationKey = licensedApplicationRole.getKey();
            if (!licensedApplications.getKeys().contains(licensedApplicationKey)) continue;
            String productName = licensedApplicationRole.getName();
            int licRoleUserLimit = licensedApplications.getUserLimit(licensedApplicationKey);
            int activeUserCount = this.applicationRoleManager.getUserCount(licensedApplicationKey);
            if (licRoleUserLimit == -1 || activeUserCount <= licRoleUserLimit) continue;
            warningMessages.add(i18nHelper.getText("jira.license.validation.product.active.user.count.exceeds.license.limit", productName));
        }
        if (!warningMessages.isEmpty()) {
            return ValidationResult.withWarningMessages((Iterable)warningMessages);
        }
        return ValidationResult.valid();
    }

    private static Set<String> getConfiguredGroupsForRole(ApplicationKey applicationToLicense) {
        ApplicationRoleStore applicationRoleStore = (ApplicationRoleStore)ComponentAccessor.getComponent(ApplicationRoleStore.class);
        ApplicationRoleStore.ApplicationRoleData applicationRoleData = applicationRoleStore.get(applicationToLicense);
        return applicationRoleData.getGroups();
    }

    private ValidationResult validateActivateExistingUsers(I18nHelper i18nHelper, LicensedApplications licensedApplications) {
        Predicate willUserBeActivated = user -> !this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) && this.applicationRoleManager.getRolesForUser(user).isEmpty();
        Predicate isLatentConfigurationPresent = roleDefinition -> roleDefinition.isDefined() && this.applicationRoleManager.getRole(((ApplicationRoleDefinitions.ApplicationRoleDefinition)roleDefinition.get()).key()).isEmpty();
        ApplicationRoleDefinitions roleDefinitions = (ApplicationRoleDefinitions)ComponentAccessor.getComponent(ApplicationRoleDefinitions.class);
        Set applicationsToLicense = licensedApplications.getKeys();
        ArrayList warnings = Lists.newArrayListWithCapacity((int)applicationsToLicense.size());
        for (ApplicationKey applicationToLicense : applicationsToLicense) {
            Set<String> groups;
            Set activableUsers;
            Option roleDefinition2 = roleDefinitions.getDefined(applicationToLicense);
            if (!isLatentConfigurationPresent.apply((Object)roleDefinition2) || (activableUsers = (groups = JiraLicenseHandler.getConfiguredGroupsForRole(applicationToLicense)).stream().map(group -> this.groupManager.getUsersInGroup(group)).flatMap(users -> users.stream()).filter(user -> willUserBeActivated.apply(user)).collect(Collectors.toSet())).isEmpty()) continue;
            warnings.add(i18nHelper.getText("jira.license.validation.activate.user", (Object)Lists.newArrayList((Object[])new Serializable[]{new Integer(activableUsers.size()), ((ApplicationRoleDefinitions.ApplicationRoleDefinition)roleDefinition2.get()).name()})));
        }
        if (!warnings.isEmpty()) {
            return ValidationResult.withWarningMessages((Iterable)warnings);
        }
        return ValidationResult.valid();
    }

    public String getServerId() {
        return this.jiraLicenseService.getServerId();
    }

    public String getSupportEntitlementNumber() {
        throw new UnsupportedOperationException("getSupportEntitlementNumber has been deprecated in favor of BaseLicenseDetails#getSupportEntitlementNumber() since 7.0 with the introduction of JIRA Applications Roles and multiple JIRA application licenses.");
    }

    @Nonnull
    public SortedSet<String> getAllSupportEntitlementNumbers() {
        return this.jiraLicenseManager.getSupportEntitlementNumbers();
    }

    @Nullable
    protected LicenseDetails getLicenseDetailsByApplicationKey(@Nonnull ApplicationKey application) {
        Preconditions.checkNotNull((Object)application, (Object)"application");
        return (LicenseDetails)Iterables.find((Iterable)this.jiraLicenseManager.getLicenses(), license -> license.hasApplication(application), null);
    }

    @Nullable
    public String getRawProductLicense(String productKey) {
        if (StringUtils.isBlank((String)productKey)) {
            return null;
        }
        Preconditions.checkArgument((boolean)ApplicationKey.isValid((String)productKey), (Object)"productKey is invalid.");
        ApplicationKey key = ApplicationKey.valueOf((String)productKey);
        LicenseDetails licenseDetails = this.getLicenseDetailsByApplicationKey(key);
        return licenseDetails != null ? licenseDetails.getLicenseString() : null;
    }

    @Nullable
    public SingleProductLicenseDetailsView getProductLicenseDetails(@Nonnull String productKey) {
        Preconditions.checkArgument((boolean)ApplicationKey.isValid((String)productKey), (Object)"productKey is invalid.");
        ApplicationKey key = ApplicationKey.valueOf((String)productKey);
        LicenseDetails licenseDetails = this.getLicenseDetailsByApplicationKey(key);
        return licenseDetails != null ? new SingleProductLicenseDetailsViewImpl(licenseDetails, productKey) : null;
    }

    @Nonnull
    public List<MultiProductLicenseDetails> getAllProductLicenses() {
        ArrayList<MultiProductLicenseDetailsImpl> productLicenses = new ArrayList<MultiProductLicenseDetailsImpl>();
        for (LicenseDetails license : this.jiraLicenseManager.getLicenses()) {
            productLicenses.add(new MultiProductLicenseDetailsImpl(license));
        }
        return Collections.unmodifiableList(productLicenses);
    }

    @Nonnull
    public MultiProductLicenseDetails decodeLicenseDetails(@Nonnull String license) {
        Preconditions.checkNotNull((Object)license, (Object)"License required");
        return new MultiProductLicenseDetailsImpl(this.jiraLicenseManager.getLicense(license));
    }

    @EventListener
    public void onLicenseChanged(com.atlassian.jira.license.LicenseChangedEvent event) {
        this.eventPublisher.publish((Object)new SalLicenseChangedEvent((LicenseDetails)event.getPreviousLicenseDetails().getOrNull(), (LicenseDetails)event.getNewLicenseDetails().getOrNull()));
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    private static class SalLicenseChangedEvent
    implements LicenseChangedEvent {
        private final BaseLicenseDetails previousLicense;
        private final BaseLicenseDetails newLicense;

        private SalLicenseChangedEvent(LicenseDetails previousLicenseDetails, LicenseDetails newLicenseDetails) {
            this.previousLicense = previousLicenseDetails == null ? null : new BaseLicenseDetailsImpl(previousLicenseDetails);
            this.newLicense = newLicenseDetails == null ? null : new BaseLicenseDetailsImpl(newLicenseDetails);
        }

        @Nullable
        public BaseLicenseDetails getPreviousLicense() {
            return this.previousLicense;
        }

        @Nullable
        public BaseLicenseDetails getNewLicense() {
            return this.newLicense;
        }
    }
}

