/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.license;

import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.sal.api.license.BaseLicenseDetails;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class BaseLicenseDetailsImpl
implements BaseLicenseDetails {
    private final LicenseDetails licenseDetails;

    BaseLicenseDetailsImpl(@Nonnull LicenseDetails licenseDetails) {
        this.licenseDetails = licenseDetails;
    }

    protected LicenseDetails getLicenseDetails() {
        return this.licenseDetails;
    }

    public boolean isEvaluationLicense() {
        return this.getJiraLicense().isEvaluation();
    }

    @Nonnull
    public String getLicenseTypeName() {
        return this.licenseDetails.getLicenseType().name();
    }

    public String getOrganisationName() {
        return this.getJiraLicense().getOrganisation().getName();
    }

    @Nullable
    public String getSupportEntitlementNumber() {
        return this.getJiraLicense().getSupportEntitlementNumber();
    }

    public String getDescription() {
        return this.getJiraLicense().getDescription();
    }

    public String getServerId() {
        return this.getJiraLicense().getServerId();
    }

    public boolean isPerpetualLicense() {
        return this.getLicenseExpiryDate() == null;
    }

    @Nullable
    public Date getLicenseExpiryDate() {
        return this.getJiraLicense().getExpiryDate();
    }

    @Nullable
    public Date getMaintenanceExpiryDate() {
        return this.getJiraLicense().getMaintenanceExpiryDate();
    }

    public boolean isDataCenter() {
        return this.licenseDetails.isDataCenter();
    }

    public boolean isEnterpriseLicensingAgreement() {
        return this.licenseDetails.isEnterpriseLicenseAgreement();
    }

    @Nullable
    public String getProperty(@Nonnull String key) {
        return this.getJiraLicense().getProperty(key);
    }

    JiraLicense getJiraLicense() {
        return this.licenseDetails.getJiraLicense();
    }
}

