/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.features;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.features.EnabledDarkFeatures;
import com.atlassian.sal.api.features.EnabledDarkFeaturesBuilder;
import com.atlassian.sal.api.features.ValidFeatureKeyPredicate;
import com.atlassian.sal.api.user.UserKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JiraDarkFeaturesManager
implements DarkFeatureManager {
    private final FeatureManager featureManager;
    private final UserManager userManager;
    private final JiraAuthenticationContext authenticationContext;

    public JiraDarkFeaturesManager(FeatureManager featureManager, UserManager userManager, JiraAuthenticationContext authenticationContext) {
        this.featureManager = featureManager;
        this.userManager = userManager;
        this.authenticationContext = authenticationContext;
    }

    public boolean isFeatureEnabledForAllUsers(String featureKey) {
        return ValidFeatureKeyPredicate.isValidFeatureKey((String)featureKey) && this.featureManager.getDarkFeatures().getGlobalEnabledFeatureKeys().contains(featureKey);
    }

    public boolean isFeatureEnabledForCurrentUser(String featureKey) {
        return ValidFeatureKeyPredicate.isValidFeatureKey((String)featureKey) && this.featureManager.getDarkFeatures().isFeatureEnabled(featureKey);
    }

    public boolean isFeatureEnabledForUser(UserKey user, String featureKey) {
        ApplicationUser applicationUser = this.resolveApplicationUser(user);
        return this.featureManager.getDarkFeaturesForUser(applicationUser).isFeatureEnabled(featureKey);
    }

    public boolean canManageFeaturesForAllUsers() {
        return this.featureManager.hasSiteEditPermission();
    }

    public void enableFeatureForAllUsers(String featureKey) {
        this.featureManager.enableSiteDarkFeature(ValidFeatureKeyPredicate.checkFeatureKey((String)featureKey));
    }

    public void disableFeatureForAllUsers(String featureKey) {
        this.featureManager.disableSiteDarkFeature(ValidFeatureKeyPredicate.checkFeatureKey((String)featureKey));
    }

    public void enableFeatureForCurrentUser(String featureKey) {
        ApplicationUser applicationUser = this.authenticationContext.getUser();
        Assertions.stateTrue((String)"Anonymous user is not supported", (applicationUser != null ? 1 : 0) != 0);
        this.enableFeatureForUser(applicationUser, featureKey);
    }

    public void enableFeatureForUser(UserKey userKey, String featureKey) {
        Assertions.is((String)"Anonymous user is not supported", (userKey != null ? 1 : 0) != 0);
        ApplicationUser applicationUser = this.resolveApplicationUser(userKey);
        this.enableFeatureForUser(applicationUser, featureKey);
    }

    private void enableFeatureForUser(@Nullable ApplicationUser user, String featureKey) {
        if (user != null) {
            this.featureManager.enableUserDarkFeature(user, ValidFeatureKeyPredicate.checkFeatureKey((String)featureKey));
        }
    }

    public void disableFeatureForCurrentUser(String featureKey) {
        ApplicationUser applicationUser = this.authenticationContext.getUser();
        Assertions.stateTrue((String)"Anonymous user is not supported", (applicationUser != null ? 1 : 0) != 0);
        this.disableFeatureForUser(applicationUser, featureKey);
    }

    public void disableFeatureForUser(UserKey userKey, String featureKey) {
        Assertions.is((String)"Anonymous user is not supported", (userKey != null ? 1 : 0) != 0);
        ApplicationUser applicationUser = this.resolveApplicationUser(userKey);
        this.disableFeatureForUser(applicationUser, featureKey);
    }

    private void disableFeatureForUser(@Nullable ApplicationUser user, String featureKey) {
        if (user != null) {
            this.featureManager.disableUserDarkFeature(user, ValidFeatureKeyPredicate.checkFeatureKey((String)featureKey));
        }
    }

    public EnabledDarkFeatures getFeaturesEnabledForAllUsers() {
        return this.createEnabledDarkFeatures(this.featureManager.getDarkFeatures());
    }

    public EnabledDarkFeatures getFeaturesEnabledForCurrentUser() {
        return this.createEnabledDarkFeatures(this.featureManager.getDarkFeatures());
    }

    public EnabledDarkFeatures getFeaturesEnabledForUser(@Nullable UserKey userKey) {
        ApplicationUser applicationUser = this.resolveApplicationUser(userKey);
        return this.createEnabledDarkFeatures(this.featureManager.getDarkFeaturesForUser(applicationUser));
    }

    @Nullable
    private ApplicationUser resolveApplicationUser(@Nullable UserKey userKey) {
        if (userKey == null) {
            return null;
        }
        ApplicationUser applicationUser = this.userManager.getUserByKey(userKey.getStringValue());
        if (applicationUser == null) {
            throw new IllegalArgumentException(String.format("The given user key '%s' could not be resolved to an existing JIRA user.", userKey.getStringValue()));
        }
        return applicationUser;
    }

    @Nonnull
    private EnabledDarkFeatures createEnabledDarkFeatures(@Nonnull DarkFeatures darkFeatures) {
        return new EnabledDarkFeaturesBuilder().unmodifiableFeaturesEnabledForAllUsers(darkFeatures.getSystemEnabledFeatures()).featuresEnabledForAllUsers(darkFeatures.getSiteEnabledFeatures()).featuresEnabledForCurrentUser(darkFeatures.getUserEnabledFeatures()).build();
    }
}

