/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.executor;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.tenancy.JiraTenantContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.atlassian.sal.core.executor.DefaultThreadLocalDelegateExecutorFactory;
import com.atlassian.sal.core.executor.ThreadLocalDelegateExecutorService;
import com.atlassian.sal.core.executor.ThreadLocalDelegateScheduledExecutorService;
import com.atlassian.sal.jira.executor.JiraThreadLocalContextManager;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.DisposableBean;

public class JiraThreadLocalDelegateExecutorFactory
extends DefaultThreadLocalDelegateExecutorFactory<JiraThreadLocalContextManager.JiraThreadLocalContext>
implements DisposableBean {
    private final List<ThreadLocalDelegateExecutorService> executorServices = Lists.newArrayList();

    public JiraThreadLocalDelegateExecutorFactory(JiraAuthenticationContext authenticationContext, VelocityRequestContextFactory velocityRequestContextFactory, JiraTenantContext tenantContext) {
        super((ThreadLocalContextManager)new JiraThreadLocalContextManager(authenticationContext, velocityRequestContextFactory, tenantContext));
    }

    public ExecutorService createExecutorService(ExecutorService delegate) {
        ThreadLocalDelegateExecutorService executorService = (ThreadLocalDelegateExecutorService)super.createExecutorService(delegate);
        this.executorServices.add(executorService);
        return executorService;
    }

    public ScheduledExecutorService createScheduledExecutorService(ScheduledExecutorService delegate) {
        ThreadLocalDelegateScheduledExecutorService scheduledExecutorService = (ThreadLocalDelegateScheduledExecutorService)super.createScheduledExecutorService(delegate);
        this.executorServices.add((ThreadLocalDelegateExecutorService)scheduledExecutorService);
        return scheduledExecutorService;
    }

    public void destroy() {
        try {
            for (ThreadLocalDelegateExecutorService executorService : this.executorServices) {
                executorService.shutdownNow();
            }
        }
        finally {
            this.executorServices.clear();
        }
    }
}

