/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.upgrade;

import com.atlassian.jira.rest.bind.DateTimeAdapter;
import com.atlassian.scheduler.status.RunDetails;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlRootElement
public class UpgradeResultBean {
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private Date startTime;
    @XmlElement
    private Long duration;
    @XmlElement
    private String outcome;
    @XmlElement
    private String message;
    static final UpgradeResultBean DOC_EXAMPLE = new UpgradeResultBean();

    public UpgradeResultBean() {
    }

    UpgradeResultBean(Date startTime, Long duration, String outcome, String message) {
        this.startTime = startTime;
        this.duration = duration;
        this.outcome = outcome;
        this.message = message;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Long getDuration() {
        return this.duration;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public String getMessage() {
        return this.message;
    }

    public static UpgradeResultBean fromRunDetails(@Nonnull RunDetails runDetails) {
        return new UpgradeResultBean(runDetails.getStartTime(), runDetails.getDurationInMillis(), runDetails.getRunOutcome().toString(), runDetails.getMessage());
    }

    static {
        UpgradeResultBean.DOC_EXAMPLE.startTime = new Date();
        UpgradeResultBean.DOC_EXAMPLE.duration = 2001L;
        UpgradeResultBean.DOC_EXAMPLE.outcome = "SUCCESS";
        UpgradeResultBean.DOC_EXAMPLE.message = "";
    }
}

