/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.upgrade;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.v2.upgrade.UpgradeResultBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.upgrade.UpgradeResult;
import com.atlassian.jira.upgrade.UpgradeScheduler;
import com.atlassian.jira.upgrade.UpgradeService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.scheduler.SchedulerHistoryService;
import com.atlassian.scheduler.status.RunDetails;
import java.net.URI;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="upgrade")
public class UpgradeResource {
    private JiraAuthenticationContext jiraAuthenticationContext;
    private PermissionManager permissionManager;
    private UpgradeService upgradeService;
    private JiraBaseUrls jiraBaseUrls;
    private final SchedulerHistoryService schedulerHistoryService;

    public UpgradeResource(JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, UpgradeService upgradeService, JiraBaseUrls jiraBaseUrls, SchedulerHistoryService schedulerHistoryService) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.upgradeService = upgradeService;
        this.jiraBaseUrls = jiraBaseUrls;
        this.schedulerHistoryService = schedulerHistoryService;
    }

    @POST
    @ResponseType(value=Void.class)
    public Response runUpgradesNow() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (!this.permissionManager.hasPermission(44, user)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        UpgradeResult status = this.upgradeService.runUpgrades();
        if (status.successful()) {
            URI location = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path("upgrade").build(new Object[0]);
            return Response.status((Response.Status)Response.Status.ACCEPTED).location(location).header("Retry-After", (Object)10).cacheControl(CacheControl.never()).build();
        }
        return Response.serverError().cacheControl(CacheControl.never()).entity((Object)status.getErrors()).build();
    }

    @GET
    @ResponseType(value=UpgradeResultBean.class)
    public Response getUpgradeResult() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (!this.permissionManager.hasPermission(0, user)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (this.upgradeService.areUpgradesRunning()) {
            URI location = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path("upgrade").build(new Object[0]);
            return Response.status((Response.Status)Response.Status.SEE_OTHER).location(location).header("Retry-After", (Object)10).cacheControl(CacheControl.never()).build();
        }
        Optional<RunDetails> lastUpgradeResult = Optional.ofNullable(this.schedulerHistoryService.getLastRunForJob(UpgradeScheduler.JOB_ID));
        return lastUpgradeResult.map(result -> Response.ok((Object)this.upgradeService.areUpgradesRunning()).entity((Object)UpgradeResultBean.fromRunDetails(result)).cacheControl(CacheControl.never()).build()).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }
}

