/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionImpl;
import com.atlassian.jira.sharing.type.ShareType;
import java.util.Optional;
import java.util.function.Function;
import org.codehaus.jackson.annotate.JsonProperty;

public class SharePermissionInputBean {
    public static SharePermissionInputBean DOC_EXAMPLE = new SharePermissionInputBean();
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="projectId")
    private String projectId;
    @JsonProperty(value="groupname")
    private String groupname;
    @JsonProperty(value="projectRoleId")
    private String projectRoleId;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getGroupname() {
        return this.groupname;
    }

    public void setGroupname(String groupname) {
        this.groupname = groupname;
    }

    public String getProjectRoleId() {
        return this.projectRoleId;
    }

    public void setProjectRoleId(String projectRoleId) {
        this.projectRoleId = projectRoleId;
    }

    static {
        DOC_EXAMPLE.setType("group");
        DOC_EXAMPLE.setGroupname("jira-administrators");
    }

    static enum Type {
        PROJECT("project", inputBean -> new SharePermissionImpl(ShareType.Name.PROJECT, ((SharePermissionInputBean)inputBean).projectId, null)),
        GROUP("group", inputBean -> new SharePermissionImpl(ShareType.Name.GROUP, ((SharePermissionInputBean)inputBean).groupname, null)),
        PROJECT_ROLE("projectRole", inputBean -> new SharePermissionImpl(ShareType.Name.PROJECT, ((SharePermissionInputBean)inputBean).projectId, ((SharePermissionInputBean)inputBean).projectRoleId)),
        GLOBAL("global", inputBean -> new SharePermissionImpl(ShareType.Name.GLOBAL, null, null)),
        AUTHENTICATED("authenticated", inputBean -> new SharePermissionImpl(ShareType.Name.AUTHENTICATED, null, null));

        private final String value;
        private final Function<SharePermissionInputBean, SharePermission> mapFunction;

        private Type(String value, Function<SharePermissionInputBean, SharePermission> mapFunction) {
            this.value = value;
            this.mapFunction = mapFunction;
        }

        public String getValue() {
            return this.value;
        }

        public static Optional<Type> fromValue(String type) {
            for (Type value : Type.values()) {
                if (!value.value.equals(type)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }

        public SharePermission buildSharePermission(SharePermissionInputBean inputBean) {
            return this.mapFunction.apply(inputBean);
        }
    }
}

