/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.permission;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.permission.LegacyProjectPermissionKeyMapping;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.rest.v2.permission.PermissionJsonBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.google.common.base.Objects;
import org.codehaus.jackson.annotate.JsonProperty;

public class UserPermissionJsonBean
extends PermissionJsonBean {
    @JsonProperty
    public boolean havePermission;
    @JsonProperty
    public Boolean deprecatedKey;

    public UserPermissionJsonBean() {
    }

    public UserPermissionJsonBean(GlobalPermissionType globalPermissionType, boolean havePermission, JiraAuthenticationContext authenticationContext) {
        Integer id = (Integer)GlobalPermissionKey.GLOBAL_PERMISSION_ID_TRANSLATION.inverse().get((Object)globalPermissionType.getGlobalPermissionKey());
        this.id(id == null ? "-1" : id.toString());
        this.key(globalPermissionType.getKey());
        this.type = PermissionJsonBean.PermissionType.GLOBAL;
        this.name = authenticationContext.getI18nHelper().getText(globalPermissionType.getNameI18nKey());
        this.description = authenticationContext.getI18nHelper().getText(globalPermissionType.getDescriptionI18nKey());
        this.havePermission = havePermission;
    }

    public UserPermissionJsonBean(ProjectPermission permission, boolean havePermission, JiraAuthenticationContext authenticationContext) {
        Integer id = LegacyProjectPermissionKeyMapping.getId((ProjectPermissionKey)permission.getProjectPermissionKey());
        this.id(id == null ? "-1" : id.toString());
        this.key(permission.getKey());
        this.type = PermissionJsonBean.PermissionType.PROJECT;
        this.name = authenticationContext.getI18nHelper().getText(permission.getNameI18nKey());
        this.description = authenticationContext.getI18nHelper().getText(permission.getDescriptionI18nKey());
        this.havePermission = havePermission;
    }

    public UserPermissionJsonBean(Permissions.Permission permission, boolean havePermission, JiraAuthenticationContext authenticationContext) {
        this.id(String.valueOf(permission.getId()));
        this.key(permission.name());
        this.type = PermissionJsonBean.PermissionType.PROJECT;
        this.name = authenticationContext.getI18nHelper().getText(permission.getNameKey());
        this.description = authenticationContext.getI18nHelper().getText(permission.getDescriptionKey());
        this.havePermission = havePermission;
        this.deprecatedKey = true;
    }

    public UserPermissionJsonBean(ProjectPermissionKey permissionKey, String name, String description, boolean havePermission) {
        Integer id = LegacyProjectPermissionKeyMapping.getId((ProjectPermissionKey)permissionKey);
        this.id(id == null ? "-1" : id.toString());
        this.key(permissionKey.permissionKey());
        this.type = PermissionJsonBean.PermissionType.PROJECT;
        this.name = name;
        this.description = description;
        this.havePermission = havePermission;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("id", (Object)this.id()).add("key", (Object)this.key()).add("name", (Object)this.name).add("type", (Object)this.type).add("description", (Object)this.description).add("deprecatedKey", (Object)this.deprecatedKey).add("havePermission", this.havePermission).toString();
    }
}

