/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.permission;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.permission.PermissionJsonBean;
import com.atlassian.jira.rest.v2.permission.PermissionsJsonBean;
import com.atlassian.jira.rest.v2.permission.UserPermissionJsonBean;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import com.atlassian.rest.annotation.ResponseType;
import java.util.HashMap;
import java.util.TreeMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@CorsAllowed
@Path(value="/")
public class PermissionsResource {
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final ProjectManager projectManager;
    private final IssueManager issueManager;
    private final ResponseFactory responseFactory;

    public PermissionsResource(PermissionManager permissionManager, JiraAuthenticationContext jiraAuthenticationContext, GlobalPermissionManager globalPermissionManager, ProjectManager projectManager, IssueManager issueManager, ResponseFactory responseFactory) {
        this.globalPermissionManager = globalPermissionManager;
        this.projectManager = projectManager;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.responseFactory = responseFactory;
    }

    @GET
    @Path(value="permissions")
    @ResponseType(value=PermissionsJsonBean.class)
    public Response getAllPermissions() {
        PermissionJsonBean permissionBean;
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getUser();
        if (loggedInUser == null || !this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, loggedInUser)) {
            return this.responseFactory.errorResponse((com.atlassian.jira.util.ErrorCollection)new SimpleErrorCollection("You need to have Administer permissions to view this resource", ErrorCollection.Reason.FORBIDDEN));
        }
        TreeMap<String, PermissionJsonBean> permissions = new TreeMap<String, PermissionJsonBean>();
        for (GlobalPermissionType globalPermission : this.globalPermissionManager.getAllGlobalPermissions()) {
            permissionBean = PermissionJsonBean.fromGlobalPermission(globalPermission, this.jiraAuthenticationContext);
            permissions.put(globalPermission.getKey(), permissionBean);
        }
        for (ProjectPermission projectPermission : this.permissionManager.getAllProjectPermissions()) {
            permissionBean = PermissionJsonBean.fromProjectPermission(projectPermission, this.jiraAuthenticationContext);
            permissions.put(projectPermission.getKey(), permissionBean);
        }
        return this.responseFactory.okNoCache(new PermissionsJsonBean(permissions));
    }

    @GET
    @Path(value="mypermissions")
    @AnonymousAllowed
    @ResponseType(value=PermissionsJsonBean.class)
    public Response getPermissions(@QueryParam(value="projectKey") String projectKey, @QueryParam(value="projectId") String projectId, @QueryParam(value="issueKey") String issueKey, @QueryParam(value="issueId") String issueId) {
        HashMap<String, UserPermissionJsonBean> permissions = new HashMap<String, UserPermissionJsonBean>();
        ErrorCollection errors = new ErrorCollection();
        Project project = this.getProjectByIdOrKey(projectKey, projectId, errors);
        Issue issue = this.getIssueByIdOrKey(issueKey, issueId, errors);
        if (errors.hasAnyErrors()) {
            return Response.status((int)errors.getStatus()).entity((Object)errors).cacheControl(CacheControl.never()).build();
        }
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getUser();
        for (Permissions.Permission permission : Permissions.Permission.values()) {
            if (Permissions.Type.GLOBAL == permission.getType()) continue;
            permissions.put(permission.name(), this.createBean(permission, issue, project, loggedInUser));
        }
        for (ProjectPermission permission : this.permissionManager.getAllProjectPermissions()) {
            permissions.put(permission.getKey(), this.createBean(permission, issue, project, loggedInUser));
        }
        for (GlobalPermissionType permission : this.globalPermissionManager.getAllGlobalPermissions()) {
            permissions.put(permission.getKey(), this.createBean(permission, loggedInUser));
        }
        return Response.ok((Object)new PermissionsJsonBean(permissions)).cacheControl(CacheControl.never()).build();
    }

    private Project getProjectByIdOrKey(String projectKey, String projectId, ErrorCollection errorCollection) {
        if (StringUtils.isNotBlank((String)projectId)) {
            try {
                Project projectObj = this.projectManager.getProjectObj(Long.valueOf(Long.parseLong(projectId)));
                if (projectObj == null) {
                    errorCollection.addErrorMessage("Could not find project with id " + projectId);
                    errorCollection.reason(ErrorCollection.Reason.NOT_FOUND);
                }
                return projectObj;
            }
            catch (NumberFormatException e) {
                errorCollection.addErrorMessage("projectId provided is not valid");
                errorCollection.reason(ErrorCollection.Reason.VALIDATION_FAILED);
            }
        } else if (StringUtils.isNotBlank((String)projectKey)) {
            Project project = this.projectManager.getProjectObjByKey(projectKey);
            if (project == null) {
                errorCollection.addErrorMessage("Could not find project with key " + projectKey);
                errorCollection.reason(ErrorCollection.Reason.NOT_FOUND);
            }
            return project;
        }
        return null;
    }

    private Issue getIssueByIdOrKey(String issueKey, String issueId, ErrorCollection errorCollection) {
        if (StringUtils.isNotBlank((String)issueId)) {
            try {
                MutableIssue issueObj = this.issueManager.getIssueObject(Long.valueOf(Long.parseLong(issueId)));
                if (issueObj == null) {
                    errorCollection.addErrorMessage("Could not find issue with id " + issueId);
                    errorCollection.reason(ErrorCollection.Reason.NOT_FOUND);
                }
                return issueObj;
            }
            catch (NumberFormatException e) {
                errorCollection.addErrorMessage("issueId provided is not valid");
                errorCollection.reason(ErrorCollection.Reason.VALIDATION_FAILED);
            }
        } else if (StringUtils.isNotBlank((String)issueKey)) {
            MutableIssue issueObj = this.issueManager.getIssueObject(issueKey);
            if (issueObj == null) {
                errorCollection.addErrorMessage("Could not find issue with key " + issueKey);
                errorCollection.reason(ErrorCollection.Reason.NOT_FOUND);
            }
            return issueObj;
        }
        return null;
    }

    private UserPermissionJsonBean createBean(ProjectPermission permission, Issue issue, Project project, ApplicationUser loggedInUser) {
        boolean hasPermission = issue != null ? this.permissionManager.hasPermission(permission.getProjectPermissionKey(), issue, loggedInUser) : (project != null ? this.permissionManager.hasPermission(permission.getProjectPermissionKey(), project, loggedInUser) : this.permissionManager.hasProjects(permission.getProjectPermissionKey(), loggedInUser));
        return new UserPermissionJsonBean(permission, hasPermission, this.jiraAuthenticationContext);
    }

    private UserPermissionJsonBean createBean(Permissions.Permission permission, Issue issue, Project project, ApplicationUser loggedInUser) {
        boolean hasPermission = issue != null ? this.permissionManager.hasPermission(new ProjectPermissionKey(permission.getId()), issue, loggedInUser) : (project != null ? this.permissionManager.hasPermission(new ProjectPermissionKey(permission.getId()), project, loggedInUser) : this.permissionManager.hasProjects(new ProjectPermissionKey(permission.getId()), loggedInUser));
        return new UserPermissionJsonBean(permission, hasPermission, this.jiraAuthenticationContext);
    }

    private UserPermissionJsonBean createBean(GlobalPermissionType permission, ApplicationUser loggedInUser) {
        boolean hasPermission = this.globalPermissionManager.hasPermission(permission.getGlobalPermissionKey(), loggedInUser);
        return new UserPermissionJsonBean(permission, hasPermission, this.jiraAuthenticationContext);
    }
}

