/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.version;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.project.version.CustomFieldWithVersionUsage;
import com.atlassian.jira.rest.v2.issue.Examples;
import com.google.common.base.Objects;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@XmlRootElement(name="version")
public class VersionIssueCountsBean {
    static final VersionIssueCountsBean DOC_EXAMPLE;
    @XmlElement
    private URI self;
    @XmlElement
    private long issuesFixedCount;
    @XmlElement
    private long issuesAffectedCount;
    @XmlElement
    private long issueCountWithCustomFieldsShowingVersion;
    @XmlElement
    private List<VersionUsageInCustomFields> customFieldUsage;

    public long getIssuesFixedCount() {
        return this.issuesFixedCount;
    }

    public long getIssuesAffectedCount() {
        return this.issuesAffectedCount;
    }

    public long getIssueCountWithCustomFieldsShowingVersion() {
        return this.issueCountWithCustomFieldsShowingVersion;
    }

    public List<VersionUsageInCustomFields> getCustomFieldNames() {
        return this.customFieldUsage;
    }

    public URI getSelf() {
        return this.self;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionIssueCountsBean that = (VersionIssueCountsBean)o;
        return Objects.equal((Object)this.issuesFixedCount, (Object)that.issuesFixedCount) && Objects.equal((Object)this.issuesAffectedCount, (Object)that.issuesAffectedCount) && Objects.equal((Object)this.issueCountWithCustomFieldsShowingVersion, (Object)that.issueCountWithCustomFieldsShowingVersion) && Objects.equal((Object)this.self, (Object)that.self) && Objects.equal(this.customFieldUsage, that.customFieldUsage);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.self, this.issuesFixedCount, this.issuesAffectedCount, this.issueCountWithCustomFieldsShowingVersion, this.customFieldUsage});
    }

    public VersionIssueCountsBean() {
    }

    VersionIssueCountsBean(long issuesFixedCount, long issuesAffectedCount, URI self, long issueCountWithCustomFieldsShowingVersion, List<VersionUsageInCustomFields> customFieldUsage) {
        this.self = self;
        this.issuesFixedCount = issuesFixedCount;
        this.issuesAffectedCount = issuesAffectedCount;
        this.issueCountWithCustomFieldsShowingVersion = issueCountWithCustomFieldsShowingVersion;
        this.customFieldUsage = customFieldUsage;
    }

    static {
        VersionIssueCountsBean bean = new VersionIssueCountsBean();
        bean.self = Examples.restURI("version/10000");
        bean.issuesFixedCount = 23L;
        bean.issuesAffectedCount = 101L;
        bean.issueCountWithCustomFieldsShowingVersion = 54L;
        bean.customFieldUsage = Arrays.asList(new VersionUsageInCustomFields(10000L, "Field1", 2L), new VersionUsageInCustomFields(10010L, "Field2", 3L));
        DOC_EXAMPLE = bean;
    }

    public static class Builder {
        private URI self;
        private long issuesAffectedCount;
        private long issuesFixedCount;
        private long issueCountWithCustomFieldsShowingVersion;
        private List<VersionUsageInCustomFields> customFieldUsage;

        public URI getSelf() {
            return this.self;
        }

        public Builder setSelf(URI self) {
            this.self = self;
            return this;
        }

        public Builder issuesFixedCount(long issuesFixedCount) {
            this.issuesFixedCount = issuesFixedCount;
            return this;
        }

        public Builder issuesAffectedCount(long issuesAffectedCount) {
            this.issuesAffectedCount = issuesAffectedCount;
            return this;
        }

        public Builder issueCountWithCustomFieldsShowingVersion(long issueCountWithCustomFieldsShowingVersion) {
            this.issueCountWithCustomFieldsShowingVersion = issueCountWithCustomFieldsShowingVersion;
            return this;
        }

        public Builder customFieldUsage(@Nullable Collection<CustomFieldWithVersionUsage> customFieldUsage) {
            this.customFieldUsage = customFieldUsage == null || customFieldUsage.isEmpty() ? null : (List)customFieldUsage.stream().map(usage -> new VersionUsageInCustomFields(usage.getCustomFieldId(), usage.getFieldName(), usage.getIssueCountWithVersionInCustomField())).collect(CollectorsUtil.toImmutableListWithSizeOf(customFieldUsage));
            return this;
        }

        public VersionIssueCountsBean build() {
            return new VersionIssueCountsBean(this.issuesFixedCount, this.issuesAffectedCount, this.self, this.issueCountWithCustomFieldsShowingVersion, this.customFieldUsage);
        }
    }

    public static class VersionUsageInCustomFields
    implements CustomFieldWithVersionUsage {
        @XmlElement
        private String fieldName;
        @XmlElement
        private long customFieldId;
        @XmlElement
        private long issueCountWithVersionInCustomField;

        public VersionUsageInCustomFields(long customFieldId, String fieldName, long issueCountWithVersionInCustomField) {
            this.fieldName = fieldName;
            this.customFieldId = customFieldId;
            this.issueCountWithVersionInCustomField = issueCountWithVersionInCustomField;
        }

        public long getCustomFieldId() {
            return this.customFieldId;
        }

        @Nullable
        public String getFieldName() {
            return this.fieldName;
        }

        public long getIssueCountWithVersionInCustomField() {
            return this.issueCountWithVersionInCustomField;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionUsageInCustomFields that = (VersionUsageInCustomFields)o;
            if (this.customFieldId != that.customFieldId) {
                return false;
            }
            if (this.issueCountWithVersionInCustomField != that.issueCountWithVersionInCustomField) {
                return false;
            }
            return this.fieldName.equals(that.fieldName);
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            result = 31 * result + (int)(this.customFieldId ^ this.customFieldId >>> 32);
            result = 31 * result + (int)(this.issueCountWithVersionInCustomField ^ this.issueCountWithVersionInCustomField >>> 32);
            return result;
        }
    }
}

