/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.project;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.project.ProjectRoleBean;
import com.atlassian.jira.rest.api.project.RoleActorBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleBeanFactory;
import com.atlassian.jira.rest.v2.issue.project.ProjectRoleResource;
import com.atlassian.jira.rest.v2.issue.project.RoleResource;
import com.atlassian.jira.security.roles.DefaultRoleActors;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorComparator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.Transformed;
import java.util.Collection;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections.CollectionUtils;

public class ProjectRoleBeanFactoryImpl
implements ProjectRoleBeanFactory {
    private final JiraBaseUrls jiraBaseUrls;
    private final AvatarService avatarService;
    private final UriInfo uriInfo;

    public ProjectRoleBeanFactoryImpl(JiraBaseUrls jiraBaseUrls, AvatarService avatarService, UriInfo uriInfo) {
        this.jiraBaseUrls = jiraBaseUrls;
        this.avatarService = avatarService;
        this.uriInfo = uriInfo;
    }

    @Override
    public ProjectRoleBean projectRole(@Nonnull Project project, @Nonnull ProjectRole projectRole) {
        ProjectRoleBean projectRoleBean = this.projectRole(projectRole, null);
        projectRoleBean.self = this.uriInfo.getBaseUriBuilder().path(ProjectRoleResource.class).path(projectRoleBean.id.toString()).build(new Object[]{project.getId()});
        return projectRoleBean;
    }

    @Override
    public ProjectRoleBean projectRole(@Nonnull Project project, @Nonnull ProjectRole projectRole, @Nonnull ProjectRoleActors projectRoleActors, final @Nullable ApplicationUser loggedInUser) {
        TreeSet sortedActors = new TreeSet(RoleActorComparator.COMPARATOR);
        sortedActors.addAll(projectRoleActors.getRoleActors());
        Collection actors = Transformed.collection(sortedActors, (Function)new Function<RoleActor, RoleActorBean>(){

            public RoleActorBean get(RoleActor actor) {
                RoleActorBean bean = RoleActorBean.convert(actor);
                bean.setAvatarUrl(ProjectRoleBeanFactoryImpl.this.avatarService.getAvatarURL(loggedInUser, bean.getName(), Avatar.Size.SMALL));
                return bean;
            }
        });
        ProjectRoleBean projectRoleBean = this.projectRole(project, projectRole);
        projectRoleBean.actors = actors;
        return projectRoleBean;
    }

    @Override
    public ProjectRoleBean projectRole(@Nonnull ProjectRole projectRole, DefaultRoleActors actors) {
        ProjectRoleBean projectRoleBean = new ProjectRoleBean();
        projectRoleBean.name = projectRole.getName();
        projectRoleBean.id = projectRole.getId();
        projectRoleBean.description = projectRole.getDescription();
        projectRoleBean.self = this.uriInfo.getBaseUriBuilder().path(RoleResource.class).path(projectRoleBean.id.toString()).build(new Object[0]);
        if (actors != null && CollectionUtils.isNotEmpty((Collection)actors.getRoleActors())) {
            projectRoleBean.actors = Transformed.collection((Collection)actors.getRoleActors(), (Function)new Function<RoleActor, RoleActorBean>(){

                public RoleActorBean get(RoleActor actor) {
                    return RoleActorBean.convert(actor);
                }
            });
        }
        return projectRoleBean;
    }

    @Override
    public ProjectRoleBean shortProjectRole(@Nonnull ProjectRole projectRole) {
        return this.projectRole(projectRole, null);
    }

    @Override
    public ProjectRoleBean shortRoleBean(@Nonnull ProjectRole projectRole) {
        ProjectRoleBean projectRoleBean = new ProjectRoleBean();
        projectRoleBean.name = projectRole.getName();
        projectRoleBean.id = projectRole.getId();
        projectRoleBean.description = projectRole.getDescription();
        projectRoleBean.self = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl()).path("role").path(projectRoleBean.id.toString()).build(new Object[0]);
        return projectRoleBean;
    }
}

