/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.attachment.operation;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.rest.factory.Responder;
import com.atlassian.jira.rest.v2.issue.attachment.operation.AttachmentOperation;
import com.atlassian.jira.util.ErrorCollection;
import javax.ws.rs.core.Response;

final class AttachmentRemoval
implements AttachmentOperation {
    private final AttachmentService attachmentService;
    private final Responder responder;

    AttachmentRemoval(AttachmentService attachmentService, Responder responder) {
        this.attachmentService = attachmentService;
        this.responder = responder;
    }

    @Override
    public Response perform(Attachment attachment, JiraServiceContext context) {
        Long attachmentId = attachment.getId();
        this.attachmentService.delete(context, attachmentId);
        ErrorCollection errors = context.getErrorCollection();
        if (errors.hasAnyErrors()) {
            return this.responder.errors(errors);
        }
        return this.responder.successfulDelete();
    }
}

