/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.attachment.authorization;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.rest.factory.JiraServiceContextFactory;
import com.atlassian.jira.rest.v2.issue.attachment.authorization.AttachmentAuthorizer;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import javax.annotation.Nullable;

final class AttachmentRemovalAuthorizer
implements AttachmentAuthorizer {
    private final AttachmentService attachmentService;
    private final JiraServiceContextFactory contextFactory;

    AttachmentRemovalAuthorizer(AttachmentService attachmentService, JiraServiceContextFactory contextFactory) {
        this.attachmentService = attachmentService;
        this.contextFactory = contextFactory;
    }

    @Override
    public boolean authorize(Attachment attachment, @Nullable ApplicationUser user) {
        Long attachmentId = attachment.getId();
        JiraServiceContext serviceContext = this.contextFactory.createContext(user);
        return this.attachmentService.canDeleteAttachment(serviceContext, attachmentId);
    }

    @Override
    public String getNoPermissionMessage(I18nHelper i18n, Object attachmentId) {
        return i18n.getText("attachment.service.error.delete.no.permission", attachmentId);
    }
}

