/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.action.screen.AddFieldToScreenUtilImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.issue.fields.screen.ProjectFieldScreenHelper;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotAuthorisedWebException;
import com.atlassian.jira.rest.v2.issue.AddFieldBean;
import com.atlassian.jira.rest.v2.issue.MoveFieldBean;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.ScreenableFieldBean;
import com.atlassian.jira.rest.v2.issue.ScreenableTabBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="screens")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ScreensResource {
    private final FieldScreenManager fieldScreenManager;
    private final FieldManager fieldManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final I18nHelper i18n;
    private final CustomFieldService customFieldService;
    private ProjectManager projectManager;
    private ProjectFieldScreenHelper projectFieldScreenHelper;

    public ScreensResource(FieldScreenManager fieldScreenManager, FieldManager fieldManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, I18nHelper i18n, CustomFieldService customFieldService, ProjectManager projectManager, ProjectFieldScreenHelper projectFieldScreenHelper) {
        this.fieldScreenManager = fieldScreenManager;
        this.fieldManager = fieldManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.i18n = i18n;
        this.customFieldService = customFieldService;
        this.projectManager = projectManager;
        this.projectFieldScreenHelper = projectFieldScreenHelper;
    }

    @GET
    @ResponseType(value=List.class, genericTypes={ScreenableTabBean.class})
    @Path(value="{screenId}/tabs")
    public Response getAllTabs(@PathParam(value="screenId") Long screenId, @QueryParam(value="projectKey") String projectKey) {
        FieldScreen fieldScreen = this.getFieldScreen(screenId);
        this.projectAdminOrAdministratorPermissionCheck(fieldScreen, projectKey);
        List tabs = fieldScreen.getTabs();
        ArrayList<ScreenableTabBean> tabBeans = new ArrayList<ScreenableTabBean>(tabs.size());
        for (FieldScreenTab tab : tabs) {
            tabBeans.add(new ScreenableTabBean(tab));
        }
        return Response.ok(tabBeans).cacheControl(CacheControl.never()).build();
    }

    @POST
    @WebSudoRequired
    @Path(value="{screenId}/tabs")
    @RequestType(value=ScreenableTabBean.class)
    @ResponseType(value=ScreenableTabBean.class)
    public Response addTab(@PathParam(value="screenId") Long screenId, ScreenableTabBean tab) {
        this.administerPermissionCheck();
        if (StringUtils.isEmpty((String)tab.name)) {
            this.throwWebException("name", this.i18n.getText("admin.screens.error.tab.empty"));
        }
        if (this.getTabByName(screenId, tab.name) != null) {
            this.throwWebException("name", this.i18n.getText("admin.screens.errors.tab.exists", tab.name));
        }
        FieldScreenTab fieldScreenTab = this.getFieldScreen(screenId).addTab(tab.name);
        return Response.ok((Object)new ScreenableTabBean(fieldScreenTab)).cacheControl(CacheControl.never()).build();
    }

    @PUT
    @WebSudoRequired
    @Path(value="{screenId}/tabs/{tabId}")
    @RequestType(value=ScreenableTabBean.class)
    @ResponseType(value=ScreenableTabBean.class)
    public Response renameTab(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, ScreenableTabBean tab) {
        this.administerPermissionCheck();
        FieldScreenTab screenTab = this.getTabById(this.getFieldScreen(screenId), tabId);
        if (StringUtils.isEmpty((String)tab.name)) {
            this.throwWebException("name", this.i18n.getText("admin.screens.error.tab.empty"));
        } else if (this.getTabByName(screenId, tab.name) != null) {
            this.throwWebException("name", this.i18n.getText("admin.screens.errors.tab.exists", tab.name));
        } else {
            screenTab.rename(tab.name);
        }
        return Response.ok((Object)tab).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @WebSudoRequired
    @Path(value="{screenId}/tabs/{tabId}")
    public Response deleteTab(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId) {
        this.administerPermissionCheck();
        FieldScreen fieldScreen = this.getFieldScreen(screenId);
        FieldScreenTab tabById = this.getTabById(fieldScreen, tabId);
        fieldScreen.removeTab(tabById.getPosition());
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @POST
    @WebSudoRequired
    @Path(value="{screenId}/tabs/{tabId}/move/{pos}")
    @ResponseType(value=Void.class)
    public Response moveTab(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, @PathParam(value="pos") Integer pos) {
        this.administerPermissionCheck();
        FieldScreen fieldScreen = this.getFieldScreen(screenId);
        FieldScreenTab tabById = this.getTabById(this.getFieldScreen(screenId), tabId);
        int size = fieldScreen.getTabs().size();
        if (pos < 0 || pos > size) {
            this.throwWebException(this.i18n.getText("admin.screens.error.tab.incorrect.pos", "" + (size - 1)));
        }
        fieldScreen.moveFieldScreenTabToPosition(tabById.getPosition(), pos.intValue());
        fieldScreen.store();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{screenId}/tabs/{tabId}/fields")
    @ResponseType(value=List.class, genericTypes={ScreenableTabBean.class})
    public Response getAllFields(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, @QueryParam(value="projectKey") String projectKey) {
        FieldScreen fieldScreen = this.getFieldScreen(screenId);
        this.projectAdminOrAdministratorPermissionCheck(fieldScreen, projectKey);
        FieldScreenTab tab = this.getTabById(fieldScreen, tabId);
        List fieldScreenLayoutItems = tab.getFieldScreenLayoutItems();
        ArrayList<ScreenableFieldBean> fieldBeans = new ArrayList<ScreenableFieldBean>(fieldScreenLayoutItems.size());
        for (FieldScreenLayoutItem fieldScreenLayoutItem : fieldScreenLayoutItems) {
            Field field = this.fieldManager.getField(fieldScreenLayoutItem.getFieldId());
            if (field == null) continue;
            fieldBeans.add(new ScreenableFieldBean(field.getId(), field.getName()));
        }
        return Response.ok(fieldBeans).cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="{screenId}/availableFields")
    @ResponseType(value=List.class, genericTypes={ScreenableTabBean.class})
    public Response getFieldsToAdd(@PathParam(value="screenId") Long screenId) {
        this.administerPermissionCheck();
        ArrayList<ScreenableFieldBean> fieldBeans = new ArrayList<ScreenableFieldBean>();
        LinkedList addableFields = new LinkedList(this.fieldManager.getOrderableFields());
        List tabs = this.getFieldScreen(screenId).getTabs();
        for (FieldScreenTab fieldScreenTab : tabs) {
            for (FieldScreenLayoutItem fieldScreenLayoutItem : fieldScreenTab.getFieldScreenLayoutItems()) {
                addableFields.remove(fieldScreenLayoutItem.getOrderableField());
            }
        }
        Iterator iterator = addableFields.iterator();
        while (iterator.hasNext()) {
            OrderableField orderableField = (OrderableField)iterator.next();
            if (!this.fieldManager.isUnscreenableField((Field)orderableField)) continue;
            iterator.remove();
        }
        Collections.sort(addableFields);
        for (OrderableField addableField : addableFields) {
            fieldBeans.add(new ScreenableFieldBean(addableField.getId(), addableField.getName()));
        }
        return Response.ok(fieldBeans).cacheControl(CacheControl.never()).build();
    }

    @DELETE
    @WebSudoRequired
    @Path(value="{screenId}/tabs/{tabId}/fields/{id}")
    public Response removeField(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, @PathParam(value="id") String id) {
        this.administerPermissionCheck();
        FieldScreenTab tab = this.getTabById(this.getFieldScreen(screenId), tabId);
        if (tab.getFieldScreenLayoutItem(id) == null) {
            this.throwWebException(this.i18n.getText("admin.screens.error.field.doesnt.exist", id));
        }
        tab.getFieldScreen().removeFieldScreenLayoutItem(id);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @POST
    @WebSudoRequired
    @Path(value="{screenId}/tabs/{tabId}/fields/{id}/move")
    @RequestType(value=MoveFieldBean.class)
    @ResponseType(value=Void.class)
    public Response moveField(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, @PathParam(value="id") String id, MoveFieldBean moveField) {
        this.administerPermissionCheck();
        FieldScreenTab tab = this.getTabById(this.getFieldScreen(screenId), tabId);
        FieldScreenLayoutItem fieldToMove = tab.getFieldScreenLayoutItem(id);
        if (fieldToMove == null) {
            this.throwWebException(this.i18n.getText("admin.screens.error.field.doesnt.exist", id));
        } else if (moveField.after != null) {
            FieldScreenLayoutItem afterFieldItem;
            int target;
            String[] split = moveField.after.getPath().split("/");
            String afterField = split[split.length - 1];
            if (tab.getFieldScreenLayoutItem(afterField) == null) {
                this.throwWebException(this.i18n.getText("admin.screens.error.field.move.invalid", id, afterField));
            }
            if ((target = (afterFieldItem = tab.getFieldScreenLayoutItem(afterField)).getPosition()) < fieldToMove.getPosition()) {
                ++target;
            }
            if (target >= tab.getFieldScreenLayoutItems().size()) {
                tab.moveFieldScreenLayoutItemLast(fieldToMove.getPosition());
            } else if (target < 0) {
                tab.moveFieldScreenLayoutItemFirst(fieldToMove.getPosition());
            } else {
                HashMap<Integer, FieldScreenLayoutItem> layoutItemMap = new HashMap<Integer, FieldScreenLayoutItem>();
                layoutItemMap.put(target, fieldToMove);
                tab.moveFieldScreenLayoutItemToPosition(layoutItemMap);
            }
        } else if (moveField.position == MoveFieldBean.Position.Last) {
            tab.moveFieldScreenLayoutItemLast(fieldToMove.getPosition());
        } else if (moveField.position == MoveFieldBean.Position.First) {
            tab.moveFieldScreenLayoutItemFirst(fieldToMove.getPosition());
        }
        return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(CacheControl.never()).build();
    }

    @POST
    @WebSudoRequired
    @Path(value="{screenId}/tabs/{tabId}/fields")
    @RequestType(value=AddFieldBean.class)
    @ResponseType(value=ScreenableFieldBean.class)
    public Response addField(@PathParam(value="screenId") Long screenId, @PathParam(value="tabId") Long tabId, AddFieldBean field) {
        this.administerPermissionCheck();
        if (field.getFieldId() == null) {
            this.throwWebException("fieldId", this.i18n.getText("admin.screens.error.field.add.required"));
        }
        Field resultField = this.addFieldToScreen(screenId, tabId, field.getFieldId());
        return Response.ok((Object)new ScreenableFieldBean(resultField.getId(), resultField.getName())).cacheControl(CacheControl.never()).build();
    }

    @POST
    @WebSudoRequired
    @Path(value="addToDefault/{fieldId}")
    @ResponseType(value=Void.class)
    public Response addFieldToDefaultScreen(@PathParam(value="fieldId") String fieldId) {
        this.administerPermissionCheck();
        FieldScreen fieldScreen = this.fieldScreenManager.getFieldScreen(FieldScreen.DEFAULT_SCREEN_ID);
        List<FieldScreenTab> sortedTabs = this.sortFieldScreenTabs(fieldScreen.getTabs());
        FieldScreenTab defaultTabOfDefaultScreen = sortedTabs.iterator().next();
        Field field = this.fieldManager.getField(fieldId);
        if (field instanceof CustomField) {
            this.addCustomField(fieldId, defaultTabOfDefaultScreen);
        } else {
            this.addFieldToScreen(FieldScreen.DEFAULT_SCREEN_ID, defaultTabOfDefaultScreen.getId(), fieldId);
        }
        return Response.ok((Object)Response.Status.CREATED).cacheControl(CacheControl.never()).build();
    }

    private List<FieldScreenTab> sortFieldScreenTabs(List<FieldScreenTab> tabs) {
        ArrayList sortedTabs = Lists.newArrayList(tabs);
        if (sortedTabs.size() > 1) {
            Collections.sort(sortedTabs, new Comparator<FieldScreenTab>(){

                @Override
                public int compare(FieldScreenTab fieldScreenTab1, FieldScreenTab fieldScreenTab2) {
                    return fieldScreenTab1.getId().compareTo(fieldScreenTab2.getId());
                }
            });
        }
        return sortedTabs;
    }

    private void addCustomField(String fieldId, FieldScreenTab defaultTabOfDefaultScreen) {
        ServiceOutcome outcome = this.customFieldService.addToScreenTabs(this.jiraAuthenticationContext.getUser(), CustomFieldUtils.getCustomFieldId((String)fieldId), (List)Lists.newArrayList((Object[])new Long[]{defaultTabOfDefaultScreen.getId()}));
        if (outcome.getErrorCollection().hasAnyErrors()) {
            this.throwWebException(outcome.getErrorCollection());
        }
    }

    private Field addFieldToScreen(Long screenId, Long tabId, String fieldId) {
        FieldScreenTab tab = this.getTabById(this.getFieldScreen(screenId), tabId);
        AddFieldToScreenUtilImpl addFieldToScreenUtil = new AddFieldToScreenUtilImpl(this.jiraAuthenticationContext, this.fieldManager, this.fieldScreenManager);
        addFieldToScreenUtil.setFieldScreenId(screenId);
        addFieldToScreenUtil.setTabPosition(tab.getPosition());
        addFieldToScreenUtil.setFieldId(new String[]{fieldId});
        addFieldToScreenUtil.setFieldPosition("" + (tab.getFieldScreenLayoutItems().size() + 1));
        com.atlassian.jira.util.ErrorCollection errorCollection = addFieldToScreenUtil.validate();
        if (errorCollection.hasAnyErrors()) {
            this.throwWebException(errorCollection);
        }
        addFieldToScreenUtil.execute();
        return this.fieldManager.getField(fieldId);
    }

    private FieldScreenTab getTabById(FieldScreen screen, Long tabId) {
        List tabs = screen.getTabs();
        for (FieldScreenTab tab : tabs) {
            if (!tab.getId().equals(tabId)) continue;
            return tab;
        }
        this.throwWebException(this.i18n.getText("admin.screens.error.tab.doesnt.exist", (Object)tabId));
        return null;
    }

    private FieldScreenTab getTabByName(Long screenId, String name) {
        List tabs = this.getFieldScreen(screenId).getTabs();
        for (FieldScreenTab tab : tabs) {
            if (!tab.getName().equals(name)) continue;
            return tab;
        }
        return null;
    }

    private FieldScreen getFieldScreen(Long screenId) {
        FieldScreen fieldScreen = this.fieldScreenManager.getFieldScreen(screenId);
        if (fieldScreen == null) {
            this.throwWebException(this.i18n.getText("admin.screens.error.doesnt.exist", "" + screenId));
        }
        return fieldScreen;
    }

    private void throwWebException(String field, String message) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addError(field, message);
        this.throwWebException((com.atlassian.jira.util.ErrorCollection)errorCollection);
    }

    private void throwWebException(String message) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        errorCollection.addErrorMessage(message);
        this.throwWebException((com.atlassian.jira.util.ErrorCollection)errorCollection);
    }

    private void throwWebException(com.atlassian.jira.util.ErrorCollection errorCollection) {
        throw new RESTException(ErrorCollection.of(errorCollection));
    }

    private void administerPermissionCheck() {
        if (!this.permissionManager.hasPermission(0, this.jiraAuthenticationContext.getUser())) {
            throw new NotAuthorisedWebException();
        }
    }

    private void projectAdminOrAdministratorPermissionCheck(FieldScreen fieldScreen, String projectKey) {
        if (projectKey == null) {
            this.administerPermissionCheck();
        } else if (!this.projectFieldScreenHelper.canUserViewFieldScreenForProject(this.jiraAuthenticationContext.getUser(), fieldScreen, this.projectManager.getProjectObjByKey(projectKey))) {
            throw new NotAuthorisedWebException();
        }
    }
}

