/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.rest.v2.issue.Examples;
import com.atlassian.jira.rest.v2.issue.ResolutionResource;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="resolution")
public class ResolutionBean {
    static final ResolutionBean DOC_EXAMPLE;
    static final ResolutionBean DOC_EXAMPLE_2;
    static final List<ResolutionBean> DOC_EXAMPLE_LIST;
    @XmlElement
    private URI self;
    @XmlElement
    private String description;
    @XmlElement
    private String iconUrl;
    @XmlElement
    private String name;
    @XmlElement
    private String id;

    public static ResolutionBean shortBean(Resolution resolution, UriInfo uriInfo) {
        ResolutionBean bean = new ResolutionBean();
        bean.self = uriInfo.getBaseUriBuilder().path(ResolutionResource.class).path(resolution.getId()).build(new Object[0]);
        bean.name = resolution.getNameTranslation();
        bean.id = resolution.getId();
        return bean;
    }

    public static ResolutionBean fullBean(Resolution resolution, UriInfo uriInfo) {
        ResolutionBean bean = ResolutionBean.shortBean(resolution, uriInfo);
        bean.description = resolution.getDescTranslation();
        return bean;
    }

    public static Collection<ResolutionBean> asBeans(Collection<? extends Resolution> priorities, UriInfo uriInfo, String baseUrl) {
        ArrayList<ResolutionBean> list = new ArrayList<ResolutionBean>(priorities.size());
        for (Resolution resolution : priorities) {
            list.add(ResolutionBean.shortBean(resolution, uriInfo));
        }
        return list;
    }

    static {
        ResolutionBean resolution = new ResolutionBean();
        resolution.self = Examples.restURI("resolution/1");
        resolution.name = "Fixed";
        resolution.description = "A fix for this issue is checked into the tree and tested.";
        resolution.iconUrl = Examples.jiraURI("images/icons/statuses/resolved.png").toString();
        DOC_EXAMPLE = resolution;
        resolution = new ResolutionBean();
        resolution.self = Examples.restURI("resolution/3");
        resolution.name = "Works as designed";
        resolution.description = "This is what it is supposed to do.";
        DOC_EXAMPLE_2 = resolution;
        DOC_EXAMPLE_LIST = EasyList.build((Object)DOC_EXAMPLE, (Object)DOC_EXAMPLE_2);
    }
}

