/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.PriorityJsonBean;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.exception.NotFoundWebException;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.ResponseType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="priority")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class PriorityResource {
    private final ConstantsManager constantsManager;
    private final I18nHelper i18n;
    private final JiraBaseUrls baseUrls;

    public PriorityResource(ConstantsManager constantsManager, I18nHelper i18n, JiraBaseUrls baseUrls) {
        this.constantsManager = constantsManager;
        this.baseUrls = baseUrls;
        this.i18n = i18n;
    }

    @GET
    @ResponseType(value=List.class, genericTypes={PriorityJsonBean.class})
    public Response getPriorities(@Context UriInfo uriInfo) {
        Collection priorities = this.constantsManager.getPriorityObjects();
        ArrayList<PriorityJsonBean> beans = new ArrayList<PriorityJsonBean>(priorities.size());
        for (Priority priority : priorities) {
            beans.add(PriorityJsonBean.fullBean((Priority)priority, (JiraBaseUrls)this.baseUrls));
        }
        return Response.ok(beans).cacheControl(CacheControl.never()).build();
    }

    @GET
    @ResponseType(value=PriorityJsonBean.class)
    @Path(value="{id}")
    public Response getPriority(@PathParam(value="id") String id) {
        Priority priority = this.constantsManager.getPriorityObject(id);
        if (priority == null) {
            throw new NotFoundWebException(ErrorCollection.of(this.i18n.getText("rest.priority.error.not.found", id)));
        }
        return Response.ok((Object)PriorityJsonBean.fullBean((Priority)priority, (JiraBaseUrls)this.baseUrls)).cacheControl(CacheControl.never()).build();
    }
}

