/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.fugue.Function2;
import com.atlassian.jira.bc.issuetype.property.IssueTypePropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBeanSelfFunctions;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueTypeWithID;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyResource;
import com.atlassian.jira.rest.v2.entity.property.EntityPropertiesKeysBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.ResponseType;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="issuetype/{issueTypeId}/properties")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IssueTypePropertyResource {
    private final BasePropertyResource<IssueTypeWithID> delegate;

    public IssueTypePropertyResource(IssueTypePropertyService issueTypePropertyService, JiraAuthenticationContext authenticationContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n) {
        this.delegate = new BasePropertyResource(issueTypePropertyService, authenticationContext, jiraBaseUrls, i18n, (Function2<Long, String, String>)new EntityPropertyBeanSelfFunctions.IssueTypePropertySelfFunction(), EntityPropertyType.ISSUE_TYPE_PROPERTY);
    }

    @ExperimentalApi
    @GET
    @ResponseType(value=EntityPropertiesKeysBean.class)
    public Response getPropertyKeys(@PathParam(value="issueTypeId") String issueTypeId) {
        return this.delegate.getPropertiesKeys(issueTypeId);
    }

    @ExperimentalApi
    @PUT
    @Path(value="/{propertyKey}")
    @ResponseType(value=Void.class)
    public Response setProperty(@PathParam(value="issueTypeId") String issueTypeId, @PathParam(value="propertyKey") String propertyKey, @Context HttpServletRequest request) {
        return this.delegate.setProperty(issueTypeId, propertyKey, request);
    }

    @ExperimentalApi
    @GET
    @Path(value="/{propertyKey}")
    @ResponseType(value=EntityPropertyBean.class)
    public Response getProperty(@PathParam(value="issueTypeId") String issueTypeId, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.getProperty(issueTypeId, propertyKey);
    }

    @ExperimentalApi
    @DELETE
    @Path(value="/{propertyKey}")
    public Response deleteProperty(@PathParam(value="issueTypeId") String issueTypeId, @PathParam(value="propertyKey") String propertyKey) {
        return this.delegate.deleteProperty(issueTypeId, propertyKey);
    }
}

