/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.issue.fields.rest.json.beans.IssueTypeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.rest.v2.issue.IssueTypeResource;
import com.atlassian.jira.rest.v2.issue.ResourceUriBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import javax.ws.rs.core.UriInfo;

public class IssueTypeBeanBuilder {
    private IssueType issueType;
    private JiraBaseUrls baseURI;
    private UriInfo context;

    public IssueTypeBeanBuilder issueType(IssueType issueType) {
        this.issueType = issueType;
        return this;
    }

    public IssueTypeBeanBuilder jiraBaseUrls(JiraBaseUrls baseURI) {
        this.baseURI = baseURI;
        return this;
    }

    public IssueTypeBeanBuilder context(UriInfo context) {
        this.context = context;
        return this;
    }

    public IssueTypeJsonBean build() {
        String iconAbsoluteURL;
        this.verifyPreconditions();
        try {
            iconAbsoluteURL = new URL(this.issueType.getIconUrl()).toString();
        }
        catch (MalformedURLException e) {
            iconAbsoluteURL = this.baseURI.baseUrl() + this.issueType.getIconUrl();
        }
        return IssueTypeJsonBean.shortBean((String)new ResourceUriBuilder().build(this.context, IssueTypeResource.class, this.issueType.getId()).toString(), (String)this.issueType.getId(), (String)this.issueType.getNameTranslation(), (String)this.issueType.getDescTranslation(), (boolean)this.issueType.isSubTask(), this.issueType.getAvatar() != null ? this.issueType.getAvatar().getId() : null, (String)iconAbsoluteURL);
    }

    public IssueTypeJsonBean buildShort() {
        return this.build();
    }

    private void verifyPreconditions() {
        this.verifyPreconditionsShort();
        if (this.baseURI == null) {
            throw new IllegalStateException("baseURI not set");
        }
    }

    private void verifyPreconditionsShort() {
        if (this.issueType == null) {
            throw new IllegalStateException("issueType not set");
        }
        if (this.context == null) {
            throw new IllegalStateException("context not set");
        }
    }
}

