/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.SecuritySchemeJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.SecuritySchemesJsonBean;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.issue.security.IssueSecuritySchemeService;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.ResponseType;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="issuesecurityschemes")
@AnonymousAllowed
@Produces(value={"application/json"})
public class IssueSecuritySchemeResource {
    private final IssueSecuritySchemeService issueSecuritySchemeService;
    private final ResponseFactory responseFactory;
    private final JiraBaseUrls baseUrls;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    public IssueSecuritySchemeResource(IssueSecuritySchemeService issueSecuritySchemeService, ResponseFactory responseFactory, JiraBaseUrls baseUrls, JiraAuthenticationContext jiraAuthenticationContext) {
        this.issueSecuritySchemeService = issueSecuritySchemeService;
        this.responseFactory = responseFactory;
        this.baseUrls = baseUrls;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @GET
    @ResponseType(value=SecuritySchemesJsonBean.class)
    public Response getIssueSecuritySchemes() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        ServiceOutcome issueSecurityLevelSchemes = this.issueSecuritySchemeService.getIssueSecurityLevelSchemes(user);
        return (Response)this.responseFactory.validateOutcome(issueSecurityLevelSchemes).left().on((Function)new Function<Collection<IssueSecurityLevelScheme>, Response>(){

            public Response apply(Collection<IssueSecurityLevelScheme> issueSecurityLevelSchemes) {
                return IssueSecuritySchemeResource.this.responseFactory.okNoCache(SecuritySchemesJsonBean.fromList((List)SecuritySchemeJsonBean.fromIssueSecuritySchemes(new ArrayList<IssueSecurityLevelScheme>(issueSecurityLevelSchemes), (JiraBaseUrls)IssueSecuritySchemeResource.this.baseUrls)));
            }
        });
    }

    @GET
    @Path(value="{id}")
    @ResponseType(value=SecuritySchemeJsonBean.class)
    public Response getIssueSecurityScheme(final @PathParam(value="id") Long id) {
        final ApplicationUser user = this.jiraAuthenticationContext.getUser();
        ServiceOutcome issueSecurityLevelScheme = this.issueSecuritySchemeService.getIssueSecurityLevelScheme(user, id.longValue());
        return (Response)this.responseFactory.validateOutcome(issueSecurityLevelScheme).left().on((Function)new Function<IssueSecurityLevelScheme, Response>(){

            public Response apply(final IssueSecurityLevelScheme securityLevelScheme) {
                ServiceOutcome issueSecurityLevels = IssueSecuritySchemeResource.this.issueSecuritySchemeService.getIssueSecurityLevels(user, id.longValue());
                return (Response)IssueSecuritySchemeResource.this.responseFactory.validateOutcome(issueSecurityLevels).left().on((Function)new Function<List<IssueSecurityLevel>, Response>(){

                    public Response apply(List<IssueSecurityLevel> issueSecurityLevels) {
                        return IssueSecuritySchemeResource.this.responseFactory.okNoCache(SecuritySchemeJsonBean.fullBean((IssueSecurityLevelScheme)securityLevelScheme, (JiraBaseUrls)IssueSecuritySchemeResource.this.baseUrls, issueSecurityLevels));
                    }
                });
            }
        });
    }
}

