/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.index;

import com.atlassian.jira.config.IndexTaskContext;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskMatcher;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Nullable;

public class TaskDescriptorHelper {
    private final TaskManager taskManager;
    private final Ordering<TaskDescriptor> byIdOrdering = new Ordering<TaskDescriptor>(){

        public int compare(TaskDescriptor left, TaskDescriptor right) {
            return Longs.compare((long)left.getTaskId(), (long)right.getTaskId());
        }
    };

    public TaskDescriptorHelper(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @Nullable
    public TaskDescriptor<IndexCommandResult> getActiveIndexTask() {
        return this.taskManager.getLiveTask((TaskContext)new IndexTaskContext());
    }

    @Nullable
    public TaskDescriptor<IndexCommandResult> getLastindexTask() {
        Collection indexingTasks = this.taskManager.findTasks(new TaskMatcher(){

            public boolean match(TaskDescriptor<?> descriptor) {
                return descriptor.getTaskContext() instanceof IndexTaskContext;
            }
        });
        if (indexingTasks.size() > 0) {
            return (TaskDescriptor)this.byIdOrdering.max((Iterable)indexingTasks);
        }
        return null;
    }

    @Nullable
    public TaskDescriptor<IndexCommandResult> getIndexTask(long taskId) {
        TaskDescriptor indexingTask = null;
        TaskDescriptor task = this.taskManager.getTask(Long.valueOf(taskId));
        if (task != null && task.getTaskContext() instanceof IndexTaskContext) {
            indexingTask = task;
        }
        return indexingTask;
    }
}

