/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.avatar;

import com.atlassian.core.util.FileSize;
import com.atlassian.core.util.thumbnail.ThumbnailDimension;
import com.atlassian.core.util.thumbnail.ThumbnailUtil;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.rest.v2.avatar.FileUtil;
import com.atlassian.jira.rest.v2.avatar.ImageFileOperations;
import com.atlassian.jira.rest.v2.avatar.UploadedAvatar;
import com.atlassian.jira.rest.v2.avatar.ValidationException;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.LimitedOutputStream;
import com.atlassian.jira.web.util.FileNameCharacterCheckerUtil;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TemporaryAvatarUploader {
    private static final List<String> CONTENT_TYPES = ImmutableList.of((Object)"image/jpeg", (Object)"image/gif", (Object)"image/png", (Object)"image/pjpeg", (Object)"image/x-png");
    private static final int DEFAULT_MAX_MEGAPIXELS = 5;
    public static final int MAX_SIDE_LENGTH = 500;
    private static final Logger log = LoggerFactory.getLogger(TemporaryAvatarUploader.class);
    private static final String TEMP_FILE_PREFIX = "JIRA-avatar";
    private static final String TEMP_FILE_EXTENSION = ".png";
    private final I18nHelper i18nHelper;
    private final ApplicationProperties applicationProperties;
    private final FileUtil fileUtil;
    private final ImageFileOperations imageFileOperations;

    @Inject
    public TemporaryAvatarUploader(I18nHelper i18nHelper, ApplicationProperties applicationProperties, FileUtil fileUtil, ImageFileOperations imageFileOperations) {
        this.i18nHelper = i18nHelper;
        this.applicationProperties = applicationProperties;
        this.fileUtil = fileUtil;
        this.imageFileOperations = imageFileOperations;
    }

    public UploadedAvatar createUploadedAvatarFromStream(InputStream stream, String fileName, String contentType, long size) throws IOException, ValidationException {
        this.validateFile(fileName, contentType);
        File uploadedFile = this.createTempFileFromBoundedStream(stream, fileName, size);
        UploadedAvatar uploadResult = this.shrinkImageDimensionsToSize(uploadedFile, contentType, 500);
        return uploadResult;
    }

    public UploadedAvatar createUploadedAvatarFromStream(InputStream inputStream, String filename, String contentType) throws IOException, ValidationException {
        this.validateFile(filename, contentType);
        File uploadedFile = this.fileUtil.createTempFile(inputStream, TEMP_FILE_PREFIX);
        UploadedAvatar uploadResult = this.shrinkImageDimensionsToSize(uploadedFile, contentType, 500);
        return uploadResult;
    }

    private void validateFile(String fileName, String contentType) throws ValidationException {
        if (!this.isImageContent(contentType)) {
            log.info("Received avatar upload with unsupported content type: " + contentType);
            throw new ValidationException(this.getText("avatarpicker.upload.contenttype.failure"));
        }
        String invalidChars = new FileNameCharacterCheckerUtil().assertFileNameDoesNotContainInvalidChars(fileName);
        if (null != invalidChars) {
            throw new ValidationException(this.i18nHelper.getText("avatarpicker.upload.filename.failure", invalidChars));
        }
    }

    private UploadedAvatar shrinkImageDimensionsToSize(File sourceFile, String originalContentType, int edgeSize) throws ValidationException, IOException {
        ThumbnailDimension sourceDimension;
        try (FileInputStream sourceIn = new FileInputStream(sourceFile);){
            sourceDimension = ThumbnailUtil.dimensionsForImage((InputStream)sourceIn);
        }
        catch (IOException e) {
            throw new ValidationException(this.i18nHelper.getText("avatarpicker.upload.image.corrupted"));
        }
        int maxPixels = this.getMaxMegaPixels();
        if (sourceDimension.getHeight() * sourceDimension.getWidth() > maxPixels * 1000000) {
            throw new ValidationException(this.i18nHelper.getText("avatarpicker.upload.too.big", (Object)maxPixels));
        }
        if (sourceDimension.getHeight() > edgeSize || sourceDimension.getWidth() > edgeSize) {
            try {
                File targetFile = this.fileUtil.createTemporaryFile(TEMP_FILE_PREFIX, TEMP_FILE_EXTENSION);
                return this.imageFileOperations.scaleImageToTempFile(sourceFile, sourceDimension, targetFile, edgeSize);
            }
            catch (IOException x) {
                throw new IOException(this.i18nHelper.getText("avatarpicker.upload.temp.io", x.getMessage()), x);
            }
        }
        return new UploadedAvatar(sourceFile, originalContentType, sourceDimension.getWidth(), sourceDimension.getHeight());
    }

    private File createTempFileFromBoundedStream(InputStream stream, String fileName, long size) throws ValidationException, IOException {
        if (0L >= size) {
            throw new ValidationException(this.getText("avatarpicker.upload.size.zero"));
        }
        try {
            return this.fileUtil.createTempFileFromBoundedStream(stream, size, TEMP_FILE_PREFIX);
        }
        catch (FileUtil.StreamSizeMismatchException sizeMismatch) {
            throw new ValidationException(this.getText("avatarpicker.upload.size.wrong"));
        }
        catch (LimitedOutputStream.TooBigIOException tooBigIOException) {
            throw new ValidationException(this.i18nHelper.getText("avatarpicker.upload.size.toobig", fileName, FileSize.format((long)tooBigIOException.getMaxSize())));
        }
        catch (IOException ioException) {
            throw new IOException(this.i18nHelper.getText("attachfile.error.io.error", fileName, ioException.getMessage()), ioException);
        }
    }

    private boolean isImageContent(String contentType) {
        return contentType != null && CONTENT_TYPES.contains(contentType.toLowerCase());
    }

    private String getText(String key) {
        return this.i18nHelper.getText(key);
    }

    private int getMaxMegaPixels() {
        String megaPixels = this.applicationProperties.getDefaultBackedString("jira.avatar.megapixels");
        if (StringUtils.isNotBlank((String)megaPixels) && StringUtils.isNumeric((String)megaPixels)) {
            return Integer.parseInt(megaPixels);
        }
        return 5;
    }
}

