/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.permissionscheme;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.PermissionGrant;
import com.atlassian.jira.permission.PermissionGrantInput;
import com.atlassian.jira.permission.PermissionScheme;
import com.atlassian.jira.permission.PermissionSchemeInput;
import com.atlassian.jira.permission.PermissionSchemeService;
import com.atlassian.jira.permission.data.PermissionGrantAsPureData;
import com.atlassian.jira.rest.api.permission.PermissionGrantBean;
import com.atlassian.jira.rest.api.permission.PermissionGrantBeanExpander;
import com.atlassian.jira.rest.api.permission.PermissionGrantsBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBeansFactory;
import com.atlassian.jira.rest.api.permission.PermissionSchemeExpandParam;
import com.atlassian.jira.rest.api.permission.PermissionSchemesBean;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.rest.annotation.RequestType;
import com.atlassian.rest.annotation.ResponseType;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="permissionscheme")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@WebSudoRequired
public final class PermissionSchemeResource {
    public static final String RESOURCE_PATH = "permissionscheme";
    public static final String ENTITY_PATH = "permission";
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionSchemeBeansFactory beansFactory;
    private final PermissionGrantBeanExpander permissionGrantBeanExpander;
    private final PermissionSchemeService permissionSchemeService;
    private final I18nHelper i18n;
    private final ResponseFactory responseFactory;
    private final GlobalPermissionManager globalPermissionManager;

    public PermissionSchemeResource(JiraAuthenticationContext authenticationContext, PermissionSchemeBeansFactory beansFactory, PermissionGrantBeanExpander permissionGrantBeanExpander, PermissionSchemeService permissionSchemeService, I18nHelper i18n, ResponseFactory responseFactory, GlobalPermissionManager globalPermissionManager) {
        this.authenticationContext = authenticationContext;
        this.beansFactory = beansFactory;
        this.permissionGrantBeanExpander = permissionGrantBeanExpander;
        this.permissionSchemeService = permissionSchemeService;
        this.i18n = i18n;
        this.responseFactory = responseFactory;
        this.globalPermissionManager = globalPermissionManager;
    }

    @GET
    @ResponseType(value=PermissionSchemesBean.class)
    public Response getPermissionSchemes(@QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((Function)new Function<List<PermissionSchemeExpandParam>, Response>(){

            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                ServiceOutcome permissionSchemes = PermissionSchemeResource.this.permissionSchemeService.getPermissionSchemes(PermissionSchemeResource.this.getUser());
                return (Response)PermissionSchemeResource.this.responseFactory.validateOutcome(permissionSchemes).left().on((Function)new Function<List<PermissionScheme>, Response>(){

                    public Response apply(List<PermissionScheme> permissionSchemes) {
                        ImmutableList result = ImmutableList.copyOf((Iterable)Iterables.transform(permissionSchemes, (Function)new Function<PermissionScheme, PermissionSchemeBean>(){

                            public PermissionSchemeBean apply(PermissionScheme scheme) {
                                return PermissionSchemeResource.this.beansFactory.toBean(scheme, expands);
                            }
                        }));
                        return PermissionSchemeResource.this.responseFactory.okNoCache(new PermissionSchemesBean((Iterable<PermissionSchemeBean>)result));
                    }
                });
            }
        });
    }

    @GET
    @ResponseType(value=PermissionSchemeBean.class)
    @Path(value="{schemeId}")
    public Response getPermissionScheme(final @PathParam(value="schemeId") Long id, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((Function)new Function<List<PermissionSchemeExpandParam>, Response>(){

            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                return (Response)PermissionSchemeResource.this.responseFactory.validateOutcome(PermissionSchemeResource.this.permissionSchemeService.getPermissionScheme(PermissionSchemeResource.this.getUser(), id)).left().on((Function)new Function<PermissionScheme, Response>(){

                    public Response apply(PermissionScheme scheme) {
                        return PermissionSchemeResource.this.responseFactory.okNoCache(PermissionSchemeResource.this.beansFactory.toBean(scheme, expands));
                    }
                });
            }
        });
    }

    @DELETE
    @Path(value="{schemeId}")
    public Response deletePermissionScheme(@PathParam(value="schemeId") Long id) {
        return this.responseFactory.serviceResultToNoContentResponse(this.permissionSchemeService.deletePermissionScheme(this.getUser(), id));
    }

    @POST
    @RequestType(value=PermissionSchemeBean.class)
    @ResponseType(value=PermissionSchemeBean.class)
    public Response createPermissionScheme(final PermissionSchemeBean permissionScheme, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((Function)new Function<List<PermissionSchemeExpandParam>, Response>(){

            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                return (Response)PermissionSchemeResource.this.toResponse(PermissionSchemeResource.this.beansFactory.fromBean(permissionScheme)).left().on((Function)new Function<PermissionSchemeInput, Response>(){

                    public Response apply(PermissionSchemeInput input) {
                        ServiceOutcome createdScheme = PermissionSchemeResource.this.permissionSchemeService.createPermissionScheme(PermissionSchemeResource.this.getUser(), input);
                        return (Response)PermissionSchemeResource.this.responseFactory.validateOutcome(createdScheme).left().on((Function)new Function<PermissionScheme, Response>(){

                            public Response apply(PermissionScheme scheme) {
                                PermissionSchemeBean created = PermissionSchemeResource.this.beansFactory.toBean(scheme, expands);
                                return PermissionSchemeResource.this.responseFactory.created(created.getSelf(), created);
                            }
                        });
                    }
                });
            }
        });
    }

    @PUT
    @Path(value="{schemeId}")
    @RequestType(value=PermissionSchemeBean.class)
    @ResponseType(value=PermissionSchemeBean.class)
    public Response updatePermissionScheme(final @PathParam(value="schemeId") Long schemeId, final PermissionSchemeBean permissionScheme, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((Function)new Function<List<PermissionSchemeExpandParam>, Response>(){

            public Response apply(List<PermissionSchemeExpandParam> expands) {
                return PermissionSchemeResource.this.updatePermissionScheme(schemeId, (Function<PermissionScheme, Either<ErrorCollection, PermissionSchemeInput>>)oldScheme -> PermissionSchemeResource.this.beansFactory.fromBean(permissionScheme).map((Function)new Function<PermissionSchemeInput, PermissionSchemeInput>(){

                    public PermissionSchemeInput apply(PermissionSchemeInput newScheme) {
                        if (permissionScheme.getPermissions() == null) {
                            return PermissionSchemeInput.builder((PermissionScheme)oldScheme).setName(newScheme.getName()).setDescription((String)newScheme.getDescription().getOrNull()).build();
                        }
                        return newScheme;
                    }
                }), (Function<PermissionScheme, Response>)updatedScheme -> PermissionSchemeResource.this.responseFactory.okNoCache(PermissionSchemeResource.this.beansFactory.toBean((PermissionScheme)updatedScheme, expands)));
            }
        });
    }

    @GET
    @ResponseType(value=PermissionGrantsBean.class)
    @Path(value="{schemeId}/permission")
    public Response getPermissionSchemeGrants(final @PathParam(value="schemeId") Long schemeId, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((Function)new Function<List<PermissionSchemeExpandParam>, Response>(){

            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                return (Response)PermissionSchemeResource.this.responseFactory.validateOutcome(PermissionSchemeResource.this.permissionSchemeService.getPermissionScheme(PermissionSchemeResource.this.getUser(), schemeId)).left().on((Function)new Function<PermissionScheme, Response>(){

                    public Response apply(PermissionScheme scheme) {
                        return PermissionSchemeResource.this.responseFactory.okNoCache(new PermissionGrantsBean((Iterable<PermissionGrantBean>)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)scheme.getPermissions(), (Function)new Function<PermissionGrant, PermissionGrantBean>(){

                            public PermissionGrantBean apply(PermissionGrant grant) {
                                return PermissionSchemeResource.this.beansFactory.toBean(grant, schemeId, expands);
                            }
                        }))));
                    }
                });
            }
        });
    }

    @POST
    @RequestType(value=PermissionGrantBean.class)
    @ResponseType(value=PermissionGrantBean.class)
    @Path(value="{schemeId}/permission")
    public Response createPermissionGrant(final @PathParam(value="schemeId") Long schemeId, final PermissionGrantBean grantBean, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((Function)new Function<List<PermissionSchemeExpandParam>, Response>(){

            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                return PermissionSchemeResource.this.asAdmin(() -> (Response)PermissionSchemeResource.this.toResponse(PermissionSchemeResource.this.beansFactory.fromBean(grantBean)).left().on((Function)new Function<PermissionGrantInput, Response>(){

                    public Response apply(PermissionGrantInput newPermission) {
                        return PermissionSchemeResource.this.updatePermissionScheme(schemeId, (Function<PermissionScheme, Either<ErrorCollection, PermissionSchemeInput>>)oldScheme -> PermissionSchemeResource.this.validateThatNewPermissionDoesNotAlreadyExist(oldScheme, newPermission).map((Function)new Function<PermissionGrantInput, PermissionSchemeInput>(){

                            public PermissionSchemeInput apply(PermissionGrantInput input) {
                                return PermissionSchemeInput.builder((PermissionScheme)oldScheme).addPermission(input).build();
                            }
                        }), (Function<PermissionScheme, Response>)newScheme -> {
                            PermissionGrant createdPermission = (PermissionGrant)Iterables.find((Iterable)newScheme.getPermissions(), (Predicate)PermissionGrantAsPureData.equalToModuloId((PermissionGrantInput)newPermission));
                            PermissionGrantBean createdPermissionBean = PermissionSchemeResource.this.beansFactory.toBean(createdPermission, schemeId, expands);
                            return PermissionSchemeResource.this.responseFactory.created(createdPermissionBean.getSelf(), createdPermissionBean);
                        });
                    }
                }));
            }
        });
    }

    @DELETE
    @Path(value="{schemeId}/permission/{permissionId}")
    public Response deletePermissionSchemeEntity(@PathParam(value="schemeId") Long schemeId, final @PathParam(value="permissionId") Long permissionId) {
        return this.asAdmin(() -> this.updatePermissionScheme(schemeId, (Function<PermissionScheme, Either<ErrorCollection, PermissionSchemeInput>>)((Function)scheme -> {
            if (!this.findPermissionGrant((PermissionScheme)scheme, permissionId).isPresent()) {
                return Either.left((Object)ErrorCollections.create((String)this.i18n.getText("rest.permissionscheme.permission.grant.does.not.exist", permissionId.toString()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED));
            }
            Iterable newPermissionSet = Iterables.filter((Iterable)scheme.getPermissions(), (Predicate)new Predicate<PermissionGrant>(){

                public boolean apply(PermissionGrant grant) {
                    return !grant.getId().equals(permissionId);
                }
            });
            return Either.right((Object)PermissionSchemeInput.builder((PermissionScheme)scheme).setOriginalPermissions(newPermissionSet).build());
        }), (Function<PermissionScheme, Response>)((Function)input -> this.responseFactory.noContent())));
    }

    private Response updatePermissionScheme(final Long schemeId, final Function<PermissionScheme, Either<ErrorCollection, PermissionSchemeInput>> oldToNew, final Function<PermissionScheme, Response> newSchemeToResponse) {
        return (Response)this.responseFactory.validateOutcome(this.permissionSchemeService.getPermissionScheme(this.getUser(), schemeId)).left().on((Function)new Function<PermissionScheme, Response>(){

            public Response apply(PermissionScheme scheme) {
                return (Response)PermissionSchemeResource.this.toResponse((Either)oldToNew.apply((Object)scheme)).left().on((Function)new Function<PermissionSchemeInput, Response>(){

                    public Response apply(PermissionSchemeInput newScheme) {
                        return (Response)PermissionSchemeResource.this.responseFactory.validateOutcome(PermissionSchemeResource.this.permissionSchemeService.updatePermissionScheme(PermissionSchemeResource.this.getUser(), schemeId, newScheme)).left().on((Function)new Function<PermissionScheme, Response>(){

                            public Response apply(PermissionScheme createdScheme) {
                                return (Response)newSchemeToResponse.apply((Object)createdScheme);
                            }
                        });
                    }
                });
            }
        });
    }

    @GET
    @ResponseType(value=PermissionGrantBean.class)
    @Path(value="{schemeId}/permission/{permissionId}")
    public Response getPermissionSchemeGrant(final @PathParam(value="schemeId") Long schemeId, final @PathParam(value="permissionId") Long permissionId, @QueryParam(value="expand") String expand) {
        return (Response)this.withParsedExpandParameter(expand).left().on((Function)new Function<List<PermissionSchemeExpandParam>, Response>(){

            public Response apply(final List<PermissionSchemeExpandParam> expands) {
                return (Response)PermissionSchemeResource.this.responseFactory.validateOutcome(PermissionSchemeResource.this.permissionSchemeService.getPermissionScheme(PermissionSchemeResource.this.getUser(), schemeId)).left().on((Function)new Function<PermissionScheme, Response>(){

                    public Response apply(PermissionScheme permissionScheme) {
                        Optional maybeEntity = PermissionSchemeResource.this.findPermissionGrant(permissionScheme, permissionId);
                        if (maybeEntity.isPresent()) {
                            return PermissionSchemeResource.this.responseFactory.okNoCache(PermissionSchemeResource.this.beansFactory.toBean((PermissionGrant)maybeEntity.get(), schemeId, expands));
                        }
                        return PermissionSchemeResource.this.responseFactory.errorResponse(ErrorCollections.create((String)PermissionSchemeResource.this.i18n.getText("rest.permissionscheme.permission.grant.does.not.exist", permissionId.toString()), (ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND));
                    }
                });
            }
        });
    }

    private Optional<PermissionGrant> findPermissionGrant(PermissionScheme permissionScheme, final Long permissionId) {
        return Iterables.tryFind((Iterable)permissionScheme.getPermissions(), (Predicate)new Predicate<PermissionGrant>(){

            public boolean apply(PermissionGrant grant) {
                return grant.getId().equals(permissionId);
            }
        });
    }

    private ApplicationUser getUser() {
        return this.authenticationContext.getUser();
    }

    private Either<Response, List<PermissionSchemeExpandParam>> withParsedExpandParameter(String parameter) {
        return this.toResponse(this.permissionGrantBeanExpander.parseExpandQuery(parameter));
    }

    private <T> Either<Response, T> toResponse(Either<ErrorCollection, T> either) {
        return this.responseFactory.toResponse(either);
    }

    private Either<ErrorCollection, PermissionGrantInput> validateThatNewPermissionDoesNotAlreadyExist(PermissionScheme oldScheme, PermissionGrantInput newPermission) {
        if (Iterables.contains((Iterable)Iterables.transform((Iterable)oldScheme.getPermissions(), (Function)PermissionGrantAsPureData.TO_PURE_DATA), (Object)PermissionGrantAsPureData.of((PermissionGrantInput)newPermission))) {
            return Either.left((Object)ErrorCollections.create((String)this.i18n.getText("rest.permissionscheme.permission.already.exists", newPermission.getPermission().permissionKey(), newPermission.getHolder().getType().toString(), (String)newPermission.getHolder().getParameter().getOrNull(), oldScheme.getId().toString()), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED));
        }
        return Either.right((Object)newPermission);
    }

    public Response asAdmin(RestAction action) {
        if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, this.getUser())) {
            return action.perform();
        }
        return this.responseFactory.errorResponse(ErrorCollections.create((String)this.i18n.getText("rest.permissionscheme.forbidden"), (ErrorCollection.Reason)ErrorCollection.Reason.FORBIDDEN));
    }

    private static interface RestAction {
        public Response perform();
    }
}

