/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.admin.permissionscheme;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Eithers;
import com.atlassian.fugue.Option;
import com.atlassian.jira.permission.PermissionGrant;
import com.atlassian.jira.permission.PermissionGrantInput;
import com.atlassian.jira.permission.PermissionHolder;
import com.atlassian.jira.permission.PermissionHolderType;
import com.atlassian.jira.permission.PermissionScheme;
import com.atlassian.jira.permission.PermissionSchemeInput;
import com.atlassian.jira.permission.data.CustomPermissionHolderType;
import com.atlassian.jira.rest.api.permission.PermissionGrantBean;
import com.atlassian.jira.rest.api.permission.PermissionGrantBeanExpander;
import com.atlassian.jira.rest.api.permission.PermissionHolderBean;
import com.atlassian.jira.rest.api.permission.PermissionHolderTypeMapping;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBean;
import com.atlassian.jira.rest.api.permission.PermissionSchemeBeansFactory;
import com.atlassian.jira.rest.api.permission.PermissionSchemeExpandParam;
import com.atlassian.jira.rest.util.SelfLinkBuilder;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public final class PermissionSchemeBeansFactoryImpl
implements PermissionSchemeBeansFactory {
    private final PermissionGrantBeanExpander expander;
    private final SelfLinkBuilder.SelfLink selfLink;
    private final I18nHelper i18n;

    @Autowired
    public PermissionSchemeBeansFactoryImpl(SelfLinkBuilder selfLinkBuilder, PermissionGrantBeanExpander expander, I18nHelper i18n) {
        this.expander = expander;
        this.i18n = i18n;
        this.selfLink = selfLinkBuilder.path("permissionscheme");
    }

    @Override
    public PermissionSchemeBean toBean(final PermissionScheme scheme, final List<PermissionSchemeExpandParam> expands) {
        URI self = this.selfLink.path(scheme.getId().toString(), new String[0]).toUri();
        PermissionSchemeBean.Builder bean = PermissionSchemeBean.builder().setId(scheme.getId()).setName(scheme.getName()).setSelf(self).setDescription(Strings.emptyToNull((String)scheme.getDescription()));
        if (!expands.isEmpty()) {
            bean.setPermissions(Iterables.transform((Iterable)scheme.getPermissions(), (Function)new Function<PermissionGrant, PermissionGrantBean>(){

                public PermissionGrantBean apply(PermissionGrant schemeEntity) {
                    return PermissionSchemeBeansFactoryImpl.this.toBean(schemeEntity, scheme.getId(), expands);
                }
            }));
        }
        return bean.build();
    }

    @Override
    public PermissionGrantBean toBean(PermissionGrant permissionGrant, Long schemeId, List<PermissionSchemeExpandParam> expands) {
        URI self = this.selfLink.path(schemeId.toString(), "permission", permissionGrant.getId().toString()).toUri();
        PermissionHolderType type = permissionGrant.getHolder().getType();
        String holderType = PermissionHolderTypeMapping.toRestType(type);
        PermissionHolderBean holderBean = PermissionHolderBean.holderBean(holderType, (String)permissionGrant.getHolder().getParameter().getOrNull());
        return PermissionGrantBean.builder().setId(permissionGrant.getId()).setSelf(self).setHolder(this.expander.expand(holderBean, permissionGrant.getHolder().getType(), expands)).setPermission(permissionGrant.getPermission().permissionKey()).build();
    }

    @Override
    public Either<ErrorCollection, PermissionSchemeInput> fromBean(PermissionSchemeBean permissionScheme) {
        return this.validated(permissionScheme).flatMap((Function)new Function<PermissionSchemeBean, Either<ErrorCollection, PermissionSchemeInput>>(){

            public Either<ErrorCollection, PermissionSchemeInput> apply(final PermissionSchemeBean permissionScheme) {
                return PermissionSchemeBeansFactoryImpl.this.fromBean(permissionScheme.getPermissions()).map((Function)new Function<Collection<PermissionGrantInput>, PermissionSchemeInput>(){

                    public PermissionSchemeInput apply(Collection<PermissionGrantInput> permissionGrants) {
                        return PermissionSchemeInput.builder((String)permissionScheme.getName()).setDescription(permissionScheme.getDescription()).setPermissions(permissionGrants).build();
                    }
                });
            }
        });
    }

    @Override
    public Either<ErrorCollection, Collection<PermissionGrantInput>> fromBean(List<PermissionGrantBean> permissions) {
        return Eithers.sequenceRight((Iterable)Iterables.transform((Iterable)((Iterable)Objects.firstNonNull(permissions, Collections.emptyList())), (Function)new Function<PermissionGrantBean, Either<ErrorCollection, PermissionGrantInput>>(){

            public Either<ErrorCollection, PermissionGrantInput> apply(PermissionGrantBean grantBean) {
                return PermissionSchemeBeansFactoryImpl.this.fromBean(grantBean);
            }
        })).map((Function)new Function<Iterable<PermissionGrantInput>, Collection<PermissionGrantInput>>(){

            public Collection<PermissionGrantInput> apply(Iterable<PermissionGrantInput> grants) {
                return ImmutableList.copyOf(grants);
            }
        });
    }

    @Override
    public Either<ErrorCollection, PermissionGrantInput> fromBean(PermissionGrantBean grantBean) {
        return this.validated(grantBean).map((Function)new Function<PermissionGrantBean, PermissionGrantInput>(){

            public PermissionGrantInput apply(PermissionGrantBean grantBean) {
                return PermissionGrantInput.newGrant((PermissionHolder)PermissionHolder.holder((PermissionHolderType)((PermissionHolderType)PermissionSchemeBeansFactoryImpl.this.getActorType(grantBean).get()), (String)grantBean.getHolder().getParameter()), (ProjectPermissionKey)new ProjectPermissionKey(grantBean.getPermission()));
            }
        });
    }

    private Either<ErrorCollection, PermissionSchemeBean> validated(PermissionSchemeBean bean) {
        if (Strings.isNullOrEmpty((String)bean.getName())) {
            return Either.left((Object)ErrorCollections.validationError((String)"name", (String)this.i18n.getText("rest.missing.field", "name")));
        }
        return Either.right((Object)bean);
    }

    private Either<ErrorCollection, PermissionGrantBean> validated(PermissionGrantBean bean) {
        Option<PermissionHolderType> actorType = this.getActorType(bean);
        PermissionHolderBean holder = (PermissionHolderBean)Objects.firstNonNull((Object)bean.getHolder(), (Object)new PermissionHolderBean());
        ErrorCollection errors = ErrorCollections.empty();
        if (actorType.isEmpty()) {
            errors.addError("holder.type", this.i18n.getText("rest.permissionscheme.input.error.unrecognized.holder.type", holder.getType()));
        } else if (((PermissionHolderType)actorType.get()).requiresParameter() && Strings.isNullOrEmpty((String)holder.getParameter())) {
            errors.addError("holder.parameter", this.i18n.getText("rest.permissionscheme.input.error.holder.parameter.required", holder.getType()));
        } else if (!((PermissionHolderType)actorType.get()).requiresParameter() && !Strings.isNullOrEmpty((String)holder.getParameter())) {
            errors.addError("holder.parameter", this.i18n.getText("rest.permissionscheme.input.error.holder.parameter.unexpected", holder.getType()));
        }
        if (Strings.isNullOrEmpty((String)bean.getPermission())) {
            errors.addError("permission", this.i18n.getText("rest.missing.field", "permission"));
        }
        return errors.hasAnyErrors() ? Either.left((Object)errors) : Either.right((Object)bean);
    }

    private Option<PermissionHolderType> getActorType(PermissionGrantBean grantBean) {
        return Option.option((Object)grantBean.getHolder()).flatMap((Function)new Function<PermissionHolderBean, Option<PermissionHolderType>>(){

            public Option<PermissionHolderType> apply(final PermissionHolderBean holder) {
                return Option.option((Object)holder.getType()).map((Function)new Function<String, PermissionHolderType>(){

                    public PermissionHolderType apply(String holderType) {
                        return PermissionHolderTypeMapping.fromRestType(holderType).orElse(CustomPermissionHolderType.permissionHolderType((String)holderType, (String)holder.getParameter()));
                    }
                });
            }
        });
    }
}

