/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.project;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.jira.security.xsrf.XsrfInvocationChecker;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import com.atlassian.plugins.rest.common.security.XsrfCheckFailedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="project")
@Produces(value={"application/json"})
@CorsAllowed
public class ProjectAvatarResource {
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectService projectService;
    private AvatarManager avatarManager;
    private final XsrfInvocationChecker xsrfChecker;

    public ProjectAvatarResource(JiraAuthenticationContext authenticationContext, ProjectService projectService, AvatarManager avatarManager, XsrfInvocationChecker xsrfChecker) {
        this.authenticationContext = authenticationContext;
        this.projectService = projectService;
        this.avatarManager = avatarManager;
        this.xsrfChecker = xsrfChecker;
    }

    @POST
    @Path(value="{projectKey}/avatar/{avatarId}")
    public Response updateUserAvatar(@PathParam(value="projectKey") String projectKey, @PathParam(value="avatarId") Long avatarId) {
        XsrfCheckResult xsrfCheckResult = this.xsrfChecker.checkWebRequestInvocation(ExecutingHttpRequest.get());
        if (xsrfCheckResult.isRequired() && !xsrfCheckResult.isValid()) {
            throw new XsrfCheckFailedException();
        }
        if (StringUtils.isBlank((String)projectKey) || avatarId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Project key and avatarId are required parameters").cacheControl(CacheControl.NO_CACHE).build();
        }
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(this.authenticationContext.getUser(), projectKey);
        if (!projectResult.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(projectResult.getErrorCollection())).cacheControl(CacheControl.NO_CACHE).build();
        }
        Avatar avatar = this.avatarManager.getById(avatarId);
        if (avatar == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(CacheControl.NO_CACHE).build();
        }
        Project project = projectResult.getProject();
        ProjectService.UpdateProjectValidationResult updateValidationResult = this.projectService.validateUpdateProject(this.authenticationContext.getUser(), project.getName(), project.getKey(), project.getDescription(), project.getLeadUserName(), project.getUrl(), project.getAssigneeType(), avatarId);
        if (!updateValidationResult.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of(updateValidationResult.getErrorCollection())).cacheControl(CacheControl.NO_CACHE).build();
        }
        this.projectService.updateProject(updateValidationResult);
        return Response.ok().cacheControl(CacheControl.NO_CACHE).build();
    }
}

