/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v1.issues;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Iterables;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
@Produces(value={"application/json", "application/xml"})
public class IssueActionsAndOperationsResource {
    private final JiraAuthenticationContext authContext;
    private final IssueManager issueManager;
    private final I18nHelper i18n;
    private final String issueIdOrKey;
    private Issue issue;
    private final SimpleLinkManager simpleLinkManager;
    private final XsrfTokenGenerator xsrfTokenGenerator;
    private final IssueWorkflowManager issueWorkflowManager;

    public IssueActionsAndOperationsResource(JiraAuthenticationContext authContext, IssueManager issueManager, I18nHelper i18n, String issueIdOrKey, SimpleLinkManager simpleLinkManager, XsrfTokenGenerator xsrfTokenGenerator, IssueWorkflowManager issueWorkflowManager) {
        this.authContext = authContext;
        this.issueManager = issueManager;
        this.simpleLinkManager = simpleLinkManager;
        this.xsrfTokenGenerator = xsrfTokenGenerator;
        this.issueWorkflowManager = issueWorkflowManager;
        this.i18n = i18n;
        this.issueIdOrKey = issueIdOrKey;
    }

    @GET
    public Response getActionsAndOperationsResponse(@Context HttpServletRequest request) {
        return this.getActionsAndOperations(request);
    }

    private Response getActionsAndOperations(HttpServletRequest request) {
        Issue issue = this.getIssue();
        Response.ResponseBuilder responseBuilder = issue != null ? Response.ok((Object)new AvailableActionsAndOperationsWrapper(this.getIssue().getId().toString(), this.getIssue().getKey(), this.i18n.getText("admin.issue.operations.view"), this.getCurrentAtlToken(request), this.getAvailableActions(), this.getIssueOperations(request))) : Response.status((Response.Status)Response.Status.NOT_FOUND);
        return responseBuilder.cacheControl(CacheControl.NO_CACHE).build();
    }

    private List<AvailableAction> getAvailableActions() {
        Collection availableActions = this.issueWorkflowManager.getAvailableActions(this.getIssue(), this.authContext.getUser());
        HashMap<Integer, ActionDescriptor> actions = new HashMap<Integer, ActionDescriptor>();
        for (ActionDescriptor availableAction : availableActions) {
            actions.put(availableAction.getId(), availableAction);
        }
        ArrayList<AvailableAction> returnList = new ArrayList<AvailableAction>(actions.size());
        for (Map.Entry entry : actions.entrySet()) {
            returnList.add(new AvailableAction(((Integer)entry.getKey()).toString(), this.getWorkflowTransitionDisplayName((ActionDescriptor)entry.getValue()), this.getWorkflowTransitionDescription((ActionDescriptor)entry.getValue())));
        }
        return returnList;
    }

    private List<AvailableOperation> getIssueOperations(HttpServletRequest request) {
        ApplicationUser currentUser = this.authContext.getUser();
        ArrayList<AvailableOperation> operations = new ArrayList<AvailableOperation>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("issue", this.getIssue());
        params.put("issueId", this.getIssue().getId());
        JiraHelper helper = new JiraHelper(request, this.getIssue().getProjectObject(), params);
        Iterable sections = Iterables.concat((Iterable)this.simpleLinkManager.getSectionsForLocation("opsbar-operations", currentUser, helper), (Iterable)this.simpleLinkManager.getSectionsForLocation("opsbar-admin", currentUser, helper));
        for (SimpleLinkSection section : sections) {
            List links = this.simpleLinkManager.getLinksForSection(section.getId(), currentUser, helper);
            for (SimpleLink link : links) {
                AvailableOperation operation = new AvailableOperation(link.getLabel(), link.getUrl(), link.getTitle(), link.getStyleClass());
                operations.add(operation);
            }
        }
        return operations;
    }

    private Issue getIssue() {
        if (this.issue == null) {
            try {
                this.issue = this.issueManager.getIssueObject(Long.valueOf(this.issueIdOrKey));
            }
            catch (NumberFormatException nfe) {
                this.issue = this.issueManager.getIssueObject(this.issueIdOrKey);
            }
        }
        return this.issue;
    }

    private String getWorkflowTransitionDisplayName(ActionDescriptor descriptor) {
        return WorkflowUtil.getWorkflowTransitionDisplayName((ActionDescriptor)descriptor);
    }

    private String getWorkflowTransitionDescription(ActionDescriptor descriptor) {
        return StringUtils.trimToNull((String)WorkflowUtil.getWorkflowTransitionDescription((ActionDescriptor)descriptor));
    }

    private boolean isAuthenticated() {
        return this.authContext.getUser() != null;
    }

    private String getCurrentAtlToken(HttpServletRequest httpRequest) {
        return this.xsrfTokenGenerator.generateToken(httpRequest);
    }

    @XmlRootElement
    public static class AvailableActionsAndOperationsWrapper {
        @XmlElement
        private String id;
        @XmlElement
        private String key;
        @XmlElement
        private String viewIssue;
        @XmlElement
        private String atlToken;
        @XmlElement
        private List<AvailableAction> actions;
        @XmlElement
        private List<AvailableOperation> operations;

        private AvailableActionsAndOperationsWrapper() {
        }

        private AvailableActionsAndOperationsWrapper(String id, String key, String viewIssue, String atlToken, List<AvailableAction> actions, List<AvailableOperation> operations) {
            this.id = id;
            this.key = key;
            this.actions = actions;
            this.operations = operations;
            this.viewIssue = viewIssue;
            this.atlToken = atlToken;
        }
    }

    @XmlRootElement
    public static class AvailableOperation {
        @XmlElement
        private String name;
        @XmlElement
        private String url;
        @XmlElement
        private String desc;
        @XmlElement
        private String styleClass;

        private AvailableOperation() {
        }

        private AvailableOperation(String name, String url, String desc, String styleClass) {
            this.name = name;
            this.url = url;
            this.desc = desc;
            this.styleClass = styleClass;
        }
    }

    @XmlRootElement
    public static class AvailableAction {
        @XmlElement
        private String action;
        @XmlElement
        private String name;
        @XmlElement
        private String desc;

        private AvailableAction() {
        }

        private AvailableAction(String action, String name, String desc) {
            this.action = action;
            this.name = name;
            this.desc = desc;
        }
    }
}

