/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class SelfLinkBuilder {
    private final JiraBaseUrls jiraBaseUrls;

    @Autowired
    public SelfLinkBuilder(JiraBaseUrls jiraBaseUrls) {
        this.jiraBaseUrls = jiraBaseUrls;
    }

    public SelfLink path(String path) {
        return new SelfLink(Collections.singletonList(path), Collections.emptyMap());
    }

    public final class SelfLink {
        private final List<String> paths;
        private final Map<String, String> queryParams;

        private SelfLink(List<String> path, Map<String, String> queryParams) {
            this.paths = path;
            this.queryParams = queryParams;
        }

        public SelfLink path(String pathSegment, String ... pathSegments) {
            return new SelfLink((List<String>)ImmutableList.builder().addAll(this.paths).add((Object)pathSegment).add((Object[])pathSegments).build(), this.queryParams);
        }

        public SelfLink queryParam(String key, String value) {
            return new SelfLink(this.paths, (Map<String, String>)ImmutableMap.builder().putAll(this.queryParams).put((Object)key, (Object)value).build());
        }

        public URI toUri() {
            UriBuilder builder = UriBuilder.fromPath((String)SelfLinkBuilder.this.jiraBaseUrls.restApi2BaseUrl());
            for (String string : this.paths) {
                builder.path(string);
            }
            for (Map.Entry entry : this.queryParams.entrySet()) {
                builder.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
            }
            return builder.build(new Object[0]);
        }

        public String toString() {
            return this.toUri().toString();
        }
    }
}

