/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.util;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.search.IssuePickerResults;
import com.atlassian.jira.bc.issue.search.IssuePickerSearchService;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.rest.util.ProjectFinder;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.DelimeterInserter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssuePicker {
    private static final Logger log = LoggerFactory.getLogger(IssuePicker.class);
    private static final int PICKER_LIMIT = 20;
    private final IssueManager issueManager;
    private final ProjectFinder projectFinder;
    private final JiraAuthenticationContext authContext;
    private final ApplicationProperties applicationProperties;
    private final IssuePickerSearchService issuePickerSearchService;
    private final I18nHelper i18nHelper;

    @Autowired
    public IssuePicker(IssueManager issueManager, ProjectFinder projectFinder, JiraAuthenticationContext authContext, ApplicationProperties applicationProperties, IssuePickerSearchService issuePickerSearchService, I18nHelper i18nHelper) {
        this.issueManager = issueManager;
        this.projectFinder = projectFinder;
        this.authContext = authContext;
        this.applicationProperties = applicationProperties;
        this.issuePickerSearchService = issuePickerSearchService;
        this.i18nHelper = i18nHelper;
    }

    public Response getIssuesResponse(Option<String> query, final String currentJQL, String currentIssueKey, String currentProjectId, boolean showSubTasks, boolean showSubTaskParent) {
        String jql = (String)query.fold((Supplier)new Supplier<String>(){

            public String get() {
                return null;
            }
        }, (Function)new Function<String, String>(){

            public String apply(String query) {
                return StringUtils.isEmpty((String)query) ? null : currentJQL;
            }
        });
        return Response.ok((Object)this.getIssues((String)query.getOrNull(), jql, currentIssueKey, currentProjectId, showSubTasks, showSubTaskParent)).cacheControl(CacheControl.NO_CACHE).build();
    }

    private IssuePickerResult getIssues(String query, String currentJQL, String currentIssueKey, String currentProjectId, boolean showSubTasks, boolean showSubTaskParent) {
        JiraServiceContext context = this.getServiceContext();
        IssuePickerResult results = new IssuePickerResult();
        ApplicationUser user = this.authContext.getUser();
        MutableIssue currentIssue = null;
        if (StringUtils.isNotBlank((String)currentIssueKey)) {
            currentIssue = this.issueManager.getIssueObject(currentIssueKey);
        }
        int limit = this.getLimit();
        IssuePickerSearchService.IssuePickerParameters pickerParameters = new IssuePickerSearchService.IssuePickerParameters(query, currentJQL, (Issue)currentIssue, (Project)this.getProject(currentProjectId, user).getOrNull(), showSubTasks, showSubTaskParent, limit);
        Collection pickerResults = this.issuePickerSearchService.getResults(context, pickerParameters);
        for (IssuePickerResults pickerResult : pickerResults) {
            IssueSection section;
            Collection issues = pickerResult.getIssues();
            String labelKey = pickerResult.getLabel();
            String id = pickerResult.getId();
            String label = this.i18nHelper.getText(labelKey);
            if (!issues.isEmpty()) {
                section = new IssueSection(id, label, this.i18nHelper.getText("jira.ajax.autocomplete.showing.x.of.y", Integer.toString(issues.size()), Integer.toString(pickerResult.getTotalIssues())), null);
                results.addSection(section);
                for (Issue issue : issues) {
                    section.addIssue(this.getIssue(issue, pickerResult));
                }
                continue;
            }
            section = new IssueSection(id, label, null, this.i18nHelper.getText("jira.ajax.autocomplete.no.matching.issues"));
            results.addSection(section);
        }
        return results;
    }

    private Option<Project> getProject(String currentProjectId, ApplicationUser user) {
        if (StringUtils.isNotBlank((String)currentProjectId)) {
            ProjectService.GetProjectResult projectResult = this.projectFinder.getGetProjectForActionByIdOrKey(user, currentProjectId, ProjectAction.VIEW_ISSUES);
            return projectResult.isValid() ? Option.some((Object)projectResult.getProject()) : Option.none(Project.class);
        }
        return Option.none(Project.class);
    }

    private int getLimit() {
        int limit = 20;
        try {
            limit = Integer.valueOf(this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
        }
        catch (NumberFormatException nfe) {
            log.error("jira.ajax.autocomplete.limit does not exist or is an invalid number in jira-application.properties.", (Throwable)nfe);
        }
        return limit;
    }

    private IssuePickerIssue getIssue(Issue issue, IssuePickerResults result) {
        DelimeterInserter delimeterInserter = new DelimeterInserter("<b>", "</b>");
        delimeterInserter.setConsideredWhitespace("-_/\\,.+=&^%$#*@!~`'\":;<>");
        String[] keysTerms = result.getKeyTerms().toArray(new String[result.getKeyTerms().size()]);
        String[] summaryTerms = result.getSummaryTerms().toArray(new String[result.getSummaryTerms().size()]);
        String issueKey = delimeterInserter.insert(TextUtils.htmlEncode((String)issue.getKey()), keysTerms);
        String issueSummary = delimeterInserter.insert(TextUtils.htmlEncode((String)issue.getSummary()), summaryTerms);
        return new IssuePickerIssue(issue.getKey(), issueKey, this.getIconURI((Option<IssueType>)Option.option((Object)issue.getIssueTypeObject())), issueSummary, issue.getSummary());
    }

    private String getIconURI(Option<IssueType> issueTypeOption) {
        return (String)issueTypeOption.fold((Supplier)new Supplier<String>(){

            public String get() {
                return "";
            }
        }, (Function)new Function<IssueType, String>(){

            public String apply(IssueType issueType) {
                return issueType.getIconUrl();
            }
        });
    }

    private JiraServiceContext getServiceContext() {
        ApplicationUser user = this.authContext.getUser();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return new JiraServiceContextImpl(user, (ErrorCollection)errorCollection);
    }

    public static class IssuePickerIssue {
        @JsonProperty
        private final String key;
        @JsonProperty
        private final String keyHtml;
        @JsonProperty
        private final String img;
        @JsonProperty
        private final String summary;
        @JsonProperty
        private final String summaryText;

        public IssuePickerIssue(String key, String keyHtml, String img, String summary, String summaryText) {
            this.key = key;
            this.keyHtml = keyHtml;
            this.img = img;
            this.summary = summary;
            this.summaryText = summaryText;
        }

        public String getKey() {
            return this.key;
        }

        public String getKeyHtml() {
            return this.keyHtml;
        }

        public String getImg() {
            return this.img;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getSummaryText() {
            return this.summaryText;
        }
    }

    public static class IssueSection {
        @JsonProperty
        private final String label;
        @JsonProperty
        private final String sub;
        @JsonProperty
        private final String id;
        @JsonProperty
        private final String msg;
        @JsonProperty
        private final List<IssuePickerIssue> issues = new ArrayList<IssuePickerIssue>();

        public IssueSection(String id, String label, String sub, String msg) {
            this.label = label;
            this.sub = sub;
            this.id = id;
            this.msg = msg;
        }

        public void addIssue(IssuePickerIssue issue) {
            this.issues.add(issue);
        }

        public String getLabel() {
            return this.label;
        }

        public String getSub() {
            return this.sub;
        }

        public String getId() {
            return this.id;
        }

        public String getMsg() {
            return this.msg;
        }

        public List<IssuePickerIssue> getIssues() {
            return this.issues;
        }
    }

    public static class IssuePickerResult {
        @JsonProperty
        private final List<IssueSection> sections = new ArrayList<IssueSection>();

        public void addSection(IssueSection section) {
            this.sections.add(section);
        }

        public List<IssueSection> getSections() {
            return this.sections;
        }
    }
}

