/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.internal.v2.project;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.rest.util.ProjectFinder;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.v2.issue.project.ProjectBean;
import com.atlassian.jira.rest.v2.issue.project.ProjectBeanFactory;
import com.atlassian.jira.rest.v2.project.type.ProjectTypeBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonProperty;

@Path(value="projects")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ChangeProjectTypeDataResource {
    private final JiraAuthenticationContext authContext;
    private final ProjectFinder projectFinder;
    private final ResponseFactory responseFactory;
    private final ProjectTypeManager projectTypeManager;
    private final ProjectBeanFactory projectBeanFactory;
    private final HelpUrls helpUrls;

    public ChangeProjectTypeDataResource(@ComponentImport JiraAuthenticationContext authContext, @ComponentImport ProjectTypeManager projectTypeManager, @ComponentImport HelpUrls helpUrls, ProjectFinder projectFinder, ResponseFactory responseFactory, ProjectBeanFactory projectBeanFactory) {
        this.authContext = authContext;
        this.projectFinder = projectFinder;
        this.responseFactory = responseFactory;
        this.projectTypeManager = projectTypeManager;
        this.projectBeanFactory = projectBeanFactory;
        this.helpUrls = helpUrls;
    }

    @GET
    @Path(value="{projectIdOrKey}/changetypedata/")
    public Response getChangeProjectTypeData(@PathParam(value="projectIdOrKey") String projectIdOrKey) {
        Either<Response, Project> eitherProjectOrErrors = this.getEitherProjectOrErrors(projectIdOrKey, ProjectAction.EDIT_PROJECT_CONFIG);
        return (Response)eitherProjectOrErrors.left().on((Function)new Function<Project, Response>(){

            @Nullable
            public Response apply(Project project) {
                List projectTypeBeans = ChangeProjectTypeDataResource.this.getProjectTypeBeans(ChangeProjectTypeDataResource.this.projectTypeManager.getAllAccessibleProjectTypes());
                HelpUrl helpLink = ChangeProjectTypeDataResource.this.helpUrls.getUrl("jira_applications_overview");
                ProjectBean projectBean = ChangeProjectTypeDataResource.this.projectBeanFactory.fullProject(project, "");
                return Response.ok((Object)new ChangeProjectTypeData(projectBean, helpLink.getUrl(), projectTypeBeans)).build();
            }
        });
    }

    private Either<Response, Project> getEitherProjectOrErrors(String projectIdOrKey, ProjectAction action) {
        ProjectService.GetProjectResult projectResult = this.projectFinder.getGetProjectForActionByIdOrKey(this.authContext.getLoggedInUser(), projectIdOrKey, action);
        if (projectResult.isValid()) {
            return Either.right((Object)projectResult.getProject());
        }
        return Either.left((Object)this.responseFactory.errorResponse(projectResult.getErrorCollection()));
    }

    private List<ProjectTypeBean> getProjectTypeBeans(List<ProjectType> projectTypes) {
        return Lists.newArrayList((Iterable)Iterables.transform(projectTypes, (Function)new Function<ProjectType, ProjectTypeBean>(){

            @Nullable
            public ProjectTypeBean apply(@Nullable ProjectType projectType) {
                return ChangeProjectTypeDataResource.this.toBean(projectType);
            }
        }));
    }

    private ProjectTypeBean toBean(ProjectType projectType) {
        return new ProjectTypeBean(projectType.getKey().getKey(), projectType.getDescriptionI18nKey(), projectType.getIcon(), projectType.getColor());
    }

    public static class ChangeProjectTypeData {
        @JsonProperty
        private ProjectBean project;
        @JsonProperty
        private String helpLink;
        @JsonProperty
        private List<ProjectTypeBean> projectTypes;

        public ChangeProjectTypeData(ProjectBean project, String helpLink, List<ProjectTypeBean> projectTypes) {
            this.project = project;
            this.helpLink = helpLink;
            this.projectTypes = projectTypes;
        }

        public ProjectBean getProject() {
            return this.project;
        }

        public String getHelpLink() {
            return this.helpLink;
        }

        public List<ProjectTypeBean> getProjectTypes() {
            return this.projectTypes;
        }
    }
}

