/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.linkaggregation.jira.webhooks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.atlassian.plugins.capabilities.api.LinkedApplicationCapabilities;
import com.atlassian.sal.api.net.Request;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryWebhookSolution {
    private final Logger log = LoggerFactory.getLogger(TemporaryWebhookSolution.class);
    public static final String CONFLUENCE_CAPABILITY = "jira-metadata-aggregate-cache-invalidation";
    private final ApplicationLinkService applicationLinkService;
    private final LinkedApplicationCapabilities linkedApplicationCapabilities;

    public TemporaryWebhookSolution(ApplicationLinkService applicationLinkService, LinkedApplicationCapabilities linkedApplicationCapabilities) {
        this.applicationLinkService = applicationLinkService;
        this.linkedApplicationCapabilities = linkedApplicationCapabilities;
    }

    public void sendDeleteToConfluence(String globalId) {
        if (globalId == null || globalId.isEmpty()) {
            return;
        }
        Set linkedAppsWithCapabilities = this.linkedApplicationCapabilities.capableOf(CONFLUENCE_CAPABILITY);
        for (LinkedAppWithCapabilities linkedApp : linkedAppsWithCapabilities) {
            try {
                ApplicationLinkRequestFactory authRequestFactory;
                ApplicationLink applicationLink = this.applicationLinkService.getApplicationLink(new ApplicationId(linkedApp.getApplicationLinkId()));
                if (applicationLink == null || (authRequestFactory = applicationLink.createAuthenticatedRequestFactory(Anonymous.class)) == null) continue;
                this.log.debug("Sending DELETE to Confluence to invalidate cache, at URL " + this.getCapabilityUrl(linkedApp, globalId));
                ((ApplicationLinkRequest)authRequestFactory.createRequest(Request.MethodType.DELETE, this.getCapabilityUrl(linkedApp, globalId)).setConnectionTimeout(3000)).execute();
            }
            catch (TypeNotInstalledException e) {
                this.log.error("Application link type not installed.", (Throwable)e);
            }
            catch (CredentialsRequiredException e) {
                this.log.error("Remote link aggregation cache clearing webhook failed - credentials required.");
            }
            catch (Exception e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Remote link aggregation cache clearing webhook failed - exception.", (Throwable)e);
                    continue;
                }
                this.log.error("Remote link aggregation cache clearing webhook failed - exception.");
            }
        }
    }

    private String getCapabilityUrl(LinkedAppWithCapabilities linkedAppWithCapabilities, String globalId) {
        return linkedAppWithCapabilities.getCapabilityUrl(CONFLUENCE_CAPABILITY) + "?globalId=" + JiraUrlCodec.encode((String)globalId);
    }
}

