define('quick-edit/util/loading-indicator',[
    'jira/loading/loading',
    'jira/flag'
], function (
    Loading,
    Flag
) {
    var dim = AJS.dim;
    var undim = AJS.undim;

    return {
        showLoadingIndicator: function () {
            dim();
            Loading.showLoadingIndicator();
        },

        hideLoadingIndicator: function (showErrorFlag) {
            undim();
            Loading.hideLoadingIndicator();
            if (showErrorFlag) {
                Flag.showErrorMsg(null, AJS.I18n.getText("common.forms.ajax.commserror"));
            }
        }
    }
});