/**
 * @module quick-edit/util/dialog
 */
define('quick-edit/util/dialog', [
    'jira/dialog/dialog',
    'jira/issue',
    'jira/issuenavigator/issue-navigator'
], function(
    Dialog,
    Issue,
    IssueNavigator
){
    'use strict';

    var IssuesAPI = JIRA.Issues;

    /**
     * Gets a specific attribute from the trigger that opened the current dialog
     */
    var getAttrFromActiveTrigger = function (attr) {
        var currentDialog = Dialog.current,
            $activeTrigger = currentDialog.$activeTrigger;

        if ($activeTrigger) {
            return $activeTrigger.attr(attr);
        }
    };

    var getActionIssueKey = function () {
        var issueKey = getAttrFromActiveTrigger("data-issueKey");

        if (!issueKey && Issue.getIssueKey()) {
            issueKey = Issue.getIssueKey();
        }
        if (!issueKey && IssueNavigator.getSelectedIssueKey()) {
            issueKey = IssueNavigator.getSelectedIssueKey();
        }
        if (!issueKey && IssuesAPI) {
            // kickass
            issueKey = IssuesAPI.Api.getSelectedIssueKey();
        }
        return issueKey;
    };

    /**
     * Builds a title for an issue dialog based on if there is a data-issuekey specified on the link or it is launched
     * from the issue navigator. If there is no issue key, it just returns the action.
     *
     * @param {String} action - Prefix to title e.g Edit Issue
     * @return {String}
     */
    var getIssueActionTitle = function (action) {
        var issueKey = getActionIssueKey();

        if (!issueKey) {
            return action
        }

        return action + " : " + issueKey;
    };

    /**
     * Returns true if a Dialog's title should contain the Issue Key.
     * @return Boolean
     */
    var shouldShowIssueKeyInTitle = function() {
        return IssuesAPI || IssueNavigator.isNavigator() || getAttrFromActiveTrigger("data-issueKey");
    };

    return {
        getActionIssueKey: getActionIssueKey,
        getAttrFromActiveTrigger: getAttrFromActiveTrigger,
        getIssueActionTitle: getIssueActionTitle,
        shouldShowIssueKeyInTitle: shouldShowIssueKeyInTitle
    };
});

/**
 * @deprecated JIRA.Dialog.getActionIssueKey
 */
AJS.namespace('JIRA.Dialog.getActionIssueKey', null, require('quick-edit/util/dialog').getActionIssueKey);

/**
 * @deprecated JIRA.Dialog.getAttrFromActiveTrigger
 */
AJS.namespace('JIRA.Dialog.getAttrFromActiveTrigger', null, require('quick-edit/util/dialog').getAttrFromActiveTrigger);

/**
 * @deprecated JIRA.Dialog.getIssueActionTitle
 */
AJS.namespace('JIRA.Dialog.getIssueActionTitle', null, require('quick-edit/util/dialog').getIssueActionTitle);

/**
 * @deprecated JIRA.Dialog.shouldShowIssueKeyInTitle
 */
AJS.namespace('JIRA.Dialog.shouldShowIssueKeyInTitle', null, require('quick-edit/util/dialog').shouldShowIssueKeyInTitle);