define('quick-edit/init/create',
[
    'quick-edit/form/factory/create-issue',
    'quick-edit/form/factory/create-subtask',
    'quick-edit/util/dialog',
    'jquery'
], function(
    createIssueFormFactory,
    createSubtaskFormFactory,
    DialogUtil,
    jQuery
){
    'use strict';

    var initIssueDialog = function (e) {
        var $trigger = jQuery(e.target);
        var $a = $trigger.is("a") ? $trigger : $trigger.find("a");
        var params = parseUri($a.attr('href')).queryKey;
        // The params in the URL will be our default options, should they exist.
        var options = {
            pid: params['pid'],
            issueType: params['issuetype']
        };
        // If data attributes exist, we will prefer those over the params.
        options = jQuery.extend(options, {
            pid: $trigger.attr('data-pid'),
            issueType: $trigger.attr('data-issue-type')
        });

        createIssueFormFactory(options).asDialog({
            trigger: document.createElement("a"), // Because we're showing it manually, we don't want to have the dialog re-show for a different dialog.
            id: "create-issue-dialog",
            windowTitle: AJS.I18n.getText('admin.issue.operations.create')
        }).show();
    };

    var initSubtaskDialog = function (e) {
        var $trigger = jQuery(e.target);
        var $a = $trigger.is("a") ? $trigger : $trigger.find("a");

        var options = {
            parentIssueId: $a.attr("data-issueid")
        };

        createSubtaskFormFactory(options).asDialog({
            windowTitle: function () {
                return DialogUtil.getIssueActionTitle(AJS.I18n.getText("issue.create.subtask"));
            },
            trigger: document.createElement("a"),
            id: "create-subtask-dialog"
        }).show();
    };

    return {
        initIssueDialog: initIssueDialog,
        initSubtaskDialog: initSubtaskDialog
    };
});
